/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.OptionsBuilder;
import org.walkmod.WalkModFacade;
import org.walkmod.commands.Command;

@Parameters(separators="=", commandDescription="Sets an specific reader for an specific chain.")
public class SetReaderCommand
implements Command {
    @Parameter(arity=1, description="The reader type identifier", required=false)
    public List<String> readerType;
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    private JCommander jcommander;
    @Parameter(names={"--chain"}, description="The chain identifier", required=false)
    private String chain = "default";
    @Parameter(names={"--path", "-d"}, description="The reader path", required=false)
    private String path = "src/main/java";
    @Parameter(names={"--recursive", "-R"}, description="Removes the transformation to all submodules")
    private boolean recursive = false;
    @Parameter(names={"-e", "--verbose"}, description="Prints the stacktrace of the produced error during the execution")
    private Boolean printErrors = false;
    @DynamicParameter(names={"-D"}, description="Dynamic reader parameters go here")
    private Map<String, String> params = new HashMap<String, String>();

    public SetReaderCommand(JCommander jcommander) {
        this.jcommander = jcommander;
    }

    public SetReaderCommand(String readerType, String chain) {
        this.chain = chain;
        this.readerType = new LinkedList<String>();
        this.readerType.add(readerType);
    }

    @Override
    public void execute() throws Exception {
        if (this.help) {
            this.jcommander.usage("set-reader");
        } else {
            WalkModFacade facade = new WalkModFacade(OptionsBuilder.options().printErrors(this.printErrors));
            if (this.readerType != null) {
                facade.setReader(this.chain, this.readerType.get(0), this.path, this.recursive, this.params);
            } else {
                facade.setReader(this.chain, null, this.path, this.recursive, this.params);
            }
        }
    }
}

