/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.walkmod.OptionsBuilder;
import org.walkmod.WalkModFacade;
import org.walkmod.commands.Command;

@Parameters(separators="=", commandDescription="Removes a list of transformations from your configuration.")
public class RemoveTransformationCommand
implements Command {
    @Parameter(description="The list of transformation types", required=true)
    private List<String> types = null;
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    private JCommander jcommander;
    @Parameter(names={"--chain"}, description="The chain name")
    private String chain = "default";
    @Parameter(names={"--recursive", "-R"}, description="Removes the transformation to all submodules")
    private boolean recursive = false;
    @Parameter(names={"-e", "--verbose"}, description="Prints the stacktrace of the produced error during the execution")
    private Boolean printErrors = false;

    public RemoveTransformationCommand(JCommander jcommander) {
        this.jcommander = jcommander;
    }

    @Override
    public void execute() throws Exception {
        if (this.help) {
            this.jcommander.usage("rm");
        } else {
            WalkModFacade facade = new WalkModFacade(OptionsBuilder.options().printErrors(this.printErrors));
            facade.removeTransformations(this.chain, this.types, this.recursive);
        }
    }
}

