/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.walkmod.OptionsBuilder;
import org.walkmod.WalkModFacade;
import org.walkmod.commands.Command;

@Parameters(separators="=", commandDescription="Removes include rules from the configuration.")
public class RemoveIncludesCommand
implements Command {
    @Parameter(description="List of excludes to remove", required=true)
    private List<String> includes;
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    private JCommander jcommander;
    @Parameter(names={"-e", "--verbose"}, description="Prints the stacktrace of the produced error during the execution")
    private Boolean printErrors = false;
    @Parameter(names={"--chain"}, description="The chain name")
    private String chain = "default";
    @Parameter(names={"--setToReader"}, description="If the filter is applied in the reader")
    private boolean setToReader = true;
    @Parameter(names={"--setToWriter"}, description="If the filter is applied in the writer")
    private boolean setToWriter = false;
    @Parameter(names={"--recursive", "-R"}, description="Adds the transformation to all submodules")
    private boolean recursive = false;

    public RemoveIncludesCommand(JCommander jcommander) {
        this.jcommander = jcommander;
    }

    public RemoveIncludesCommand(List<String> includes, String chain, boolean setToReader, boolean setToWriter) {
        this.includes = includes;
        this.chain = chain;
        this.setToReader = setToReader;
        this.setToWriter = setToWriter;
    }

    @Override
    public void execute() throws Exception {
        if (this.help) {
            this.jcommander.usage("rm-includes");
        } else {
            WalkModFacade facade = new WalkModFacade(OptionsBuilder.options().printErrors(this.printErrors));
            facade.removeIncludesToChain(this.chain, this.includes, this.recursive, this.setToReader, this.setToWriter);
        }
    }
}

