/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.walkmod.OptionsBuilder;
import org.walkmod.WalkModFacade;
import org.walkmod.commands.Command;

@Parameters(separators="=", commandDescription="Removes chains from the configuration.")
public class RemoveChainCommand
implements Command {
    @Parameter(description="List of chains to remove", required=true)
    private List<String> chains;
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    private JCommander jcommander;
    @Parameter(names={"--recursive", "-R"}, description="Remove the chains to all submodules")
    private boolean recursive = false;
    @Parameter(names={"-e", "--verbose"}, description="Prints the stacktrace of the produced error during the execution")
    private Boolean printErrors = false;

    public RemoveChainCommand(JCommander jcommander) {
        this.jcommander = jcommander;
    }

    @Override
    public void execute() throws Exception {
        if (this.help) {
            this.jcommander.usage("rm-chain");
        } else {
            WalkModFacade facade = new WalkModFacade(OptionsBuilder.options().printErrors(this.printErrors));
            facade.removeChains(this.chains, this.recursive);
        }
    }
}

