/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import de.vandermeer.asciitable.v2.V2_AsciiTable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.walkmod.OptionsBuilder;
import org.walkmod.WalkModFacade;
import org.walkmod.commands.AsciiTableAware;
import org.walkmod.commands.Command;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.ProviderConfig;

@Parameters(separators="=", commandDescription="Shows the list of added providers with its parameters.")
public class PrintProvidersCommand
implements Command,
AsciiTableAware {
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    private JCommander jcommander;
    private V2_AsciiTable at;
    private static Logger log = Logger.getLogger(PrintProvidersCommand.class);

    public PrintProvidersCommand(JCommander jcommander) {
        this.jcommander = jcommander;
    }

    @Override
    public void execute() throws Exception {
        if (this.help) {
            this.jcommander.usage("modules");
        } else {
            Collection<ProviderConfig> providers;
            WalkModFacade facade = new WalkModFacade(OptionsBuilder.options());
            Configuration cfg = facade.getConfiguration();
            if (cfg == null) {
                log.error((Object)"Sorry, the current directory does not contain a walkmod configuration file or it is invalid.");
            }
            this.at = new V2_AsciiTable();
            this.at.addRule();
            this.at.addRow(new Object[]{"CONFIGURATION PROVIDERS", "PARAMETERS"});
            this.at.addRule();
            if (cfg != null && (providers = cfg.getProviderConfigurations()) != null) {
                for (ProviderConfig provider : providers) {
                    Map<String, Object> params = provider.getParameters();
                    if (params == null) {
                        this.at.addRow(new Object[]{provider.getType(), ""});
                    } else {
                        Set<String> keys = params.keySet();
                        int i = 0;
                        for (String key : keys) {
                            if (i == 0) {
                                this.at.addRow(new Object[]{provider.getType(), params.get(key).toString()});
                            } else {
                                this.at.addRow(new Object[]{"", params.get(key).toString()});
                            }
                            ++i;
                        }
                    }
                    this.at.addRule();
                }
            }
            this.at.addRule();
        }
    }

    @Override
    public V2_AsciiTable getTable() {
        return this.at;
    }
}

