/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import de.vandermeer.asciitable.v2.V2_AsciiTable;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.walkmod.OptionsBuilder;
import org.walkmod.WalkModFacade;
import org.walkmod.commands.AsciiTableAware;
import org.walkmod.commands.Command;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.TransformationConfig;

@Parameters(separators="=", commandDescription="Shows the list of chains with its code transformations.")
public class PrintChainsCommand
implements Command,
AsciiTableAware {
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    private JCommander command;
    private V2_AsciiTable at = null;
    private static Logger log = Logger.getLogger(PrintChainsCommand.class);

    public PrintChainsCommand(JCommander jcommander) {
        this.command = jcommander;
    }

    @Override
    public void execute() throws Exception {
        if (this.help) {
            this.command.usage("chains");
        } else {
            Collection<ChainConfig> chains;
            WalkModFacade facade = new WalkModFacade(OptionsBuilder.options());
            Configuration cfg = facade.getConfiguration();
            this.at = new V2_AsciiTable();
            this.at.addRule();
            this.at.addRow(new Object[]{"CHAIN", "READER PATH", "WRITER PATH", "TRANSFORMATIONS"});
            this.at.addStrongRule();
            if (cfg == null) {
                this.at.addRule();
                log.error((Object)"Sorry, the current directory does not contain a walkmod configuration file or it is invalid.");
            }
            if (cfg != null && (chains = cfg.getChainConfigs()) != null) {
                for (ChainConfig cc : chains) {
                    String[] includesWriter;
                    String[] includes;
                    List<TransformationConfig> transformations = cc.getWalkerConfig().getTransformations();
                    int numTransformations = transformations.size();
                    int numReaderIncludesExcludes = 0;
                    int includesLength = 0;
                    String[] excludes = cc.getReaderConfig().getExcludes();
                    if (excludes != null) {
                        numReaderIncludesExcludes = excludes.length;
                    }
                    if ((includes = cc.getReaderConfig().getIncludes()) != null) {
                        includesLength = includes.length;
                        numReaderIncludesExcludes += includes.length;
                    }
                    int limit = numReaderIncludesExcludes + 1;
                    if (numTransformations > numReaderIncludesExcludes) {
                        limit = numTransformations;
                    }
                    int includesExcludesWriterLength = 0;
                    int includesWriterLength = 0;
                    String[] excludesWriter = cc.getWriterConfig().getExcludes();
                    if (excludesWriter != null) {
                        includesExcludesWriterLength += excludesWriter.length;
                        if (excludesWriter.length + 1 > limit) {
                            limit = excludesWriter.length + 1;
                        }
                    }
                    if ((includesWriter = cc.getWriterConfig().getIncludes()) != null) {
                        includesExcludesWriterLength += includesWriter.length;
                        includesWriterLength = includesWriter.length;
                        if (includesWriter.length + 1 > limit) {
                            limit = includesWriter.length + 1;
                        }
                    }
                    for (int i = 0; i < limit; ++i) {
                        TransformationConfig next = null;
                        String type = "";
                        if (i < numTransformations) {
                            next = transformations.get(i);
                            type = "- " + next.getType();
                        }
                        if (i == 0) {
                            this.at.addRow(new Object[]{cc.getName(), cc.getReaderConfig().getPath(), cc.getWriterConfig().getPath(), type});
                            continue;
                        }
                        String readerWildcard = "";
                        if (i - 1 < includesLength) {
                            readerWildcard = "> " + includes[i - 1];
                        } else if (i - 1 < numReaderIncludesExcludes) {
                            readerWildcard = "< " + excludes[i - 1 + includesLength];
                        }
                        String writerWildcard = "";
                        if (includesWriter != null && i - 1 < includesWriter.length) {
                            writerWildcard = "> " + includesWriter[i - 1];
                        } else if (i - 1 < includesExcludesWriterLength) {
                            writerWildcard = "< " + excludesWriter[i - 1 + includesWriterLength];
                        }
                        this.at.addRow(new Object[]{"", readerWildcard, writerWildcard, type});
                    }
                    this.at.addRule();
                }
            }
        }
    }

    @Override
    public V2_AsciiTable getTable() {
        return this.at;
    }
}

