/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.Map;
import org.walkmod.WalkModFacade;
import org.walkmod.commands.AbstractChainCommand;
import org.walkmod.commands.Command;
import org.walkmod.patches.PatchFormat;

@Parameters(separators="=", commandDescription="Generates the corresponding patches for all your code transformations.")
public class PatchCommand
extends AbstractChainCommand
implements Command {
    private JCommander command;
    @Parameter(names={"-g", "--global"}, description="Produces a global patch per file")
    private boolean patchPerFile = true;
    @Parameter(names={"-o", "--occurrence"}, description="Produces a patch per change occurrence")
    private boolean patchPerChange = false;
    @Parameter(names={"-s", "--style"}, description="Patch style (json or raw)")
    private String patchFormat = PatchFormat.RAW.name();

    public PatchCommand(JCommander command) {
        this.command = command;
    }

    @Override
    public void execute() throws Exception {
        if (this.isHelpNeeded()) {
            this.command.usage("patch");
        } else {
            Map<String, String> dynParams = this.getDynamicParams();
            dynParams.put("patchPerFile", Boolean.toString(this.patchPerFile));
            dynParams.put("patchPerChange", Boolean.toString(this.patchPerChange));
            dynParams.put("patchFormat", this.patchFormat);
            WalkModFacade facade = new WalkModFacade(this.buildOptions());
            String[] params = new String[this.getParameters().size()];
            if (params.length == 0) {
                facade.patch(new String[0]);
            } else {
                facade.patch(this.getParameters().toArray(params));
            }
        }
    }
}

