/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import de.vandermeer.asciitable.v2.V2_AsciiTable;
import java.util.Arrays;
import java.util.List;
import org.walkmod.OptionsBuilder;
import org.walkmod.WalkModFacade;
import org.walkmod.commands.AsciiTableAware;
import org.walkmod.commands.Command;
import org.walkmod.conf.entities.BeanDefinition;
import org.walkmod.conf.entities.PropertyDefinition;
import org.walkmod.conf.entities.impl.PluginConfigImpl;

@Parameters(separators="=", commandDescription="Prints the components of a walkmod plugin")
public class InspectCommand
implements Command,
AsciiTableAware {
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    private JCommander command;
    @Parameter(description="The plugin id to inspect (e.g imports-cleaner)")
    private List<String> pluginId;
    @Parameter(names={"--offline"}, description="Resolves the walkmod plugins and their dependencies in offline mode")
    private boolean offline = false;
    private V2_AsciiTable at = null;

    public InspectCommand(JCommander command) {
        this.command = command;
    }

    @Override
    public void execute() throws Exception {
        if (this.help) {
            this.command.usage("inspect");
        } else {
            WalkModFacade facade = new WalkModFacade(OptionsBuilder.options().offline(this.offline));
            List<BeanDefinition> beans = facade.inspectPlugin(new PluginConfigImpl(this.pluginId.get(0)));
            List<String> validTypesList = Arrays.asList("String", "JSONObject", "JSONArray");
            if (beans != null) {
                this.at = new V2_AsciiTable();
                this.at.addRule();
                this.at.addRow(new Object[]{"TYPE NAME (ID)", "CATEGORY", "PROPERTIES", "DESCRIPTION"});
                this.at.addStrongRule();
                for (BeanDefinition bean : beans) {
                    List<PropertyDefinition> properties = bean.getProperties();
                    if (properties == null || properties.isEmpty()) {
                        this.at.addRow(new Object[]{bean.getType(), bean.getCategory(), "", bean.getDescription()});
                    } else {
                        int i = 0;
                        for (PropertyDefinition pd : properties) {
                            if (!validTypesList.contains(pd.getType())) continue;
                            String label = pd.getName() + ":" + pd.getType();
                            if (pd.getDefaultValue() != null && pd.getDefaultValue().length() != 0) {
                                label = label + " (" + pd.getDefaultValue() + ")";
                            }
                            if (i == 0) {
                                this.at.addRow(new Object[]{bean.getType(), bean.getCategory(), label, bean.getDescription()});
                            } else {
                                this.at.addRow(new Object[]{"", "", label, ""});
                            }
                            ++i;
                        }
                    }
                    this.at.addRule();
                }
            }
        }
    }

    @Override
    public V2_AsciiTable getTable() {
        return this.at;
    }
}

