/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.OptionsBuilder;
import org.walkmod.WalkModFacade;
import org.walkmod.commands.Command;
import org.walkmod.conf.entities.PluginConfig;
import org.walkmod.conf.entities.impl.PluginConfigImpl;

@Parameters(separators="=", commandDescription="Adds plugin to the configuration file.")
public class AddPluginCommand
implements Command {
    @Parameter(description="List of plugin identifiers separated by spaces.", required=true)
    private List<String> plugins = null;
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    private JCommander command;
    @Parameter(names={"--recursive", "-R"}, description="Adds the plugin to all submodules")
    private boolean recursive = false;
    @Parameter(names={"-e", "--verbose"}, description="Prints the stacktrace of the produced error during the execution")
    private Boolean printErrors = false;

    public AddPluginCommand(JCommander command) {
        this.command = command;
    }

    public AddPluginCommand(List<String> plugins) {
        this.plugins = plugins;
    }

    public List<PluginConfig> build() {
        LinkedList<PluginConfig> result = new LinkedList<PluginConfig>();
        for (String plugin : this.plugins) {
            PluginConfigImpl pluginConfig = new PluginConfigImpl(plugin);
            result.add(pluginConfig);
        }
        return result;
    }

    @Override
    public void execute() throws Exception {
        if (this.help) {
            this.command.usage("add-plugin");
        } else {
            List<PluginConfig> list = this.build();
            for (PluginConfig pc : list) {
                WalkModFacade facade = new WalkModFacade(OptionsBuilder.options().printErrors(this.printErrors));
                facade.addPluginConfig(pc, this.recursive);
            }
        }
    }
}

