/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.OptionsBuilder;
import org.walkmod.WalkModFacade;
import org.walkmod.commands.Command;
import org.walkmod.conf.entities.ProviderConfig;
import org.walkmod.conf.entities.impl.ProviderConfigImpl;

@Parameters(separators="=", commandDescription="Adds a configuration provider.")
public class AddCfgProviderCommand
implements Command {
    @Parameter(arity=1, description="The configuration provider type identifier", required=true)
    private List<String> type;
    @DynamicParameter(names={"-D"}, description="Dynamic transformation parameters go here")
    private Map<String, String> params = new HashMap<String, String>();
    private JCommander command;
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    @Parameter(names={"--recursive", "-R"}, description="Adds the provider to all submodules")
    private boolean recursive = false;
    @Parameter(names={"-e", "--verbose"}, description="Prints the stacktrace of the produced error during the execution")
    private Boolean printErrors = false;

    public AddCfgProviderCommand(JCommander command) {
        this.command = command;
    }

    public AddCfgProviderCommand(String type, Map<String, String> params) {
        this.type = new LinkedList<String>();
        this.type.add(type);
        this.params = params;
    }

    public ProviderConfig build() throws Exception {
        ProviderConfigImpl prov = new ProviderConfigImpl();
        prov.setType(this.type.get(0));
        if (this.params != null) {
            prov.setParameters(new HashMap<String, Object>(this.params));
        }
        return prov;
    }

    @Override
    public void execute() throws Exception {
        if (this.help) {
            this.command.usage("add-provider");
        } else {
            WalkModFacade facade = new WalkModFacade(OptionsBuilder.options().printErrors(this.printErrors));
            facade.addProviderConfig(this.build(), this.recursive);
        }
    }
}

