/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.walkmod.OptionsBuilder;

public class AbstractChainCommand {
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    @Parameter(names={"--offline"}, description="Resolves the walkmod plugins and their dependencies in offline mode")
    private boolean offline = false;
    @Parameter(names={"-e", "--verbose"}, description="Prints the stacktrace of the produced error during the execution")
    private Boolean showException = null;
    @Parameter(names={"-i", "--includes"}, description="Defines a subset of files of the reader path to include")
    private ArrayList<String> includes = null;
    @Parameter(names={"-x", "--excludes"}, description="Defines a subset of files of the reader path to exclude")
    private ArrayList<String> excludes = null;
    @Parameter(names={"-p", "--path"}, description="Overrides the reader and writer paths of the selected chains")
    private String path = null;
    @DynamicParameter(names={"-D"}, description="Dynamic parameters")
    private Map<String, String> dynamicParams = new HashMap<String, String>();
    @Parameter(description="[chains to execute. If the chain does not exists, it dynamically creates one with a transformation with the same name]")
    private List<String> parameters = new ArrayList<String>();

    public boolean isHelpNeeded() {
        return this.help;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public Boolean getShowException() {
        return this.showException;
    }

    public void setShowException(Boolean showException) {
        this.showException = showException;
    }

    public ArrayList<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(ArrayList<String> includes) {
        this.includes = includes;
    }

    public ArrayList<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(ArrayList<String> excludes) {
        this.excludes = excludes;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getDynamicParams() {
        return this.dynamicParams;
    }

    public void setDynamicParams(Map<String, String> dynamicParams) {
        this.dynamicParams = dynamicParams;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public OptionsBuilder buildOptions() {
        String[] includesArray = null;
        String[] excludesArray = null;
        if (this.includes != null && !this.includes.isEmpty()) {
            includesArray = new String[this.includes.size()];
            this.includes.toArray(includesArray);
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            excludesArray = new String[this.excludes.size()];
            this.excludes.toArray(excludesArray);
        }
        this.offline = this.offline;
        this.showException = this.showException != null && this.showException == true;
        HashMap<String, Object> dynamicArgs = new HashMap<String, Object>();
        dynamicArgs.putAll(this.dynamicParams);
        return OptionsBuilder.options().verbose(true).offline(this.offline).printErrors(this.showException).includes(includesArray).excludes(excludesArray).dynamicArgs(dynamicArgs).path(this.path);
    }
}

