/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.walkmod.Options;
import org.walkmod.OptionsBuilder;
import org.walkmod.WalkmodCommand;
import org.walkmod.conf.ConfigurationManager;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.ExecutionModeEnum;
import org.walkmod.conf.Initializer;
import org.walkmod.conf.ProjectConfigurationProvider;
import org.walkmod.conf.entities.BeanDefinition;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.InitializerConfig;
import org.walkmod.conf.entities.PluginConfig;
import org.walkmod.conf.entities.ProviderConfig;
import org.walkmod.conf.entities.TransformationConfig;
import org.walkmod.conf.entities.impl.ConfigurationImpl;
import org.walkmod.conf.providers.DynamicConfigurationProvider;
import org.walkmod.conf.providers.ExecutionModeProvider;
import org.walkmod.conf.providers.IvyConfigurationProvider;
import org.walkmod.exceptions.InvalidConfigurationException;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.writers.Summary;

public class WalkModFacade {
    protected static Logger log = Logger.getLogger(WalkModFacade.class);
    private static final String DEFAULT_WALKMOD_FILE_NAME = "walkmod";
    private Options options;
    private String userDir = ".";
    private File cfg;
    private ConfigurationProvider configurationProvider;

    public WalkModFacade(OptionsBuilder optionsBuilder) {
        this(null, optionsBuilder, null);
    }

    public WalkModFacade(File walkmodCfg, OptionsBuilder optionsBuilder, ConfigurationProvider configurationProvider) {
        this.options = optionsBuilder.build();
        this.cfg = walkmodCfg != null ? walkmodCfg.getAbsoluteFile() : new File(this.options.getExecutionDirectory().getAbsolutePath(), "walkmod." + this.options.getConfigurationFormat());
        if (configurationProvider != null) {
            this.configurationProvider = configurationProvider;
        }
    }

    private ConfigurationProvider locateConfigurationProvider() {
        if (this.configurationProvider == null) {
            return new IvyConfigurationProvider(this.options.isOffline());
        }
        return this.configurationProvider;
    }

    public List<File> apply(String ... chains) throws InvalidConfigurationException {
        final LinkedList<File> result = new LinkedList<File>();
        this.run(result, new WalkmodCommand(){

            @Override
            public void execute(Options options, File executionDir, String ... chains) throws Exception {
                WalkModFacade facade = new WalkModFacade(null, OptionsBuilder.options(options.asMap()).executionDirectory(executionDir), null);
                result.addAll(facade.apply(chains));
            }
        }, ExecutionModeEnum.APPLY, chains);
        return result;
    }

    private void printConfigError(Exception e) throws InvalidConfigurationException {
        System.setProperty("user.dir", this.userDir);
        if (this.options.isVerbose()) {
            if (!this.options.isPrintErrors()) {
                log.error((Object)(this.cfg.getAbsolutePath() + " is invalid. Please, execute walkmod with -e to see the details."));
            } else {
                log.error((Object)"Invalid configuration", (Throwable)e);
            }
            if (this.options.isThrowException()) {
                RuntimeException re = new RuntimeException();
                re.setStackTrace(e.getStackTrace());
                throw re;
            }
        } else {
            throw new InvalidConfigurationException(e);
        }
    }

    private Configuration readConfig(ConfigurationProvider ... cp) throws InvalidConfigurationException {
        Configuration config = null;
        try {
            ConfigurationManager cfgManager = new ConfigurationManager(this.cfg, cp);
            config = cfgManager.getConfiguration();
            config.setParameters(this.options.getDynamicArgs());
        }
        catch (Exception e) {
            this.printConfigError(e);
        }
        return config;
    }

    private Configuration createConfig(String[] chains, ConfigurationProvider ... cp) throws InvalidConfigurationException {
        Configuration config = new ConfigurationImpl();
        try {
            DynamicConfigurationProvider first = new DynamicConfigurationProvider(this.options, chains);
            first.init(config);
            first.load();
            ConfigurationManager cfgManager = new ConfigurationManager(config, cp);
            config = cfgManager.getConfiguration();
            config.setParameters(this.options.getDynamicArgs());
        }
        catch (Exception e) {
            this.printConfigError(e);
        }
        return config;
    }

    public List<File> patch(String ... chains) throws InvalidConfigurationException {
        final LinkedList<File> result = new LinkedList<File>();
        this.run(result, new WalkmodCommand(){

            @Override
            public void execute(Options options, File executionDir, String ... chains) throws Exception {
                WalkModFacade facade = new WalkModFacade(null, OptionsBuilder.options(options.asMap()).executionDirectory(executionDir), null);
                result.addAll(facade.patch(chains));
            }
        }, ExecutionModeEnum.PATCH, chains);
        return result;
    }

    private void run(List<File> result, WalkmodCommand command, ExecutionModeEnum execMode, String ... chains) throws InvalidConfigurationException {
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        Configuration config = null;
        if (this.cfg.exists()) {
            if (this.options.isVerbose()) {
                log.info((Object)(this.cfg.getAbsoluteFile() + " [ok]"));
            }
            config = this.readConfig(this.locateConfigurationProvider(), new ExecutionModeProvider(execMode));
        } else {
            config = this.createConfig(chains, this.locateConfigurationProvider(), new ExecutionModeProvider(execMode));
        }
        try {
            config.executeModuleChains(this.options, command, chains);
        }
        catch (Exception e) {
            System.setProperty("user.dir", this.userDir);
            if (this.options.isVerbose()) {
                if (!this.options.isPrintErrors()) {
                    log.error((Object)(this.cfg.getAbsolutePath() + " is invalid. Please, execute walkmod with -e to see the details."));
                } else {
                    log.error((Object)"Invalid configuration", (Throwable)e);
                }
                if (this.options.isThrowException()) {
                    RuntimeException re = new RuntimeException();
                    re.setStackTrace(e.getStackTrace());
                    throw re;
                }
            }
            throw new InvalidConfigurationException(e);
        }
        config.execute(this.userDir, this.options, chains);
        result.addAll(Summary.getInstance().getWrittenFiles());
        System.setProperty("user.dir", this.userDir);
    }

    public List<File> check(String ... chains) throws InvalidConfigurationException {
        final LinkedList<File> result = new LinkedList<File>();
        this.run(result, new WalkmodCommand(){

            @Override
            public void execute(Options options, File executionDir, String ... chains) throws Exception {
                WalkModFacade facade = new WalkModFacade(null, OptionsBuilder.options(options.asMap()).executionDirectory(executionDir), null);
                result.addAll(facade.check(chains));
            }
        }, ExecutionModeEnum.CHECK, chains);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public void init() throws Exception {
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        if (!this.cfg.exists()) {
            manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[]{this.locateConfigurationProvider()});
            cfgProvider = manager.getProjectConfigurationProvider();
            try {
                cfgProvider.createConfig();
                manager.executeConfigurationProviders();
                conf = manager.getConfiguration();
                initializers = conf.getInitializers();
                if (initializers != null) {
                    for (InitializerConfig initCfg : initializers) {
                        beanId = initCfg.getPluginGroupId() + ":walkmod-" + initCfg.getPluginArtifactId() + "-plugin:" + initCfg.getType();
                        if (!conf.containsBean(beanId) || (o = conf.getBean(beanId, initCfg.getParams())) == null || !(o instanceof Initializer)) continue;
                        ((Initializer)o).execute(cfgProvider);
                    }
                }
                if (!this.options.isVerbose()) ** GOTO lbl30
                WalkModFacade.log.info((Object)("CONFIGURATION FILE [" + this.cfg.getAbsolutePath() + "] CREATION COMPLETE"));
            }
            catch (IOException aux) {
                if (this.options.isVerbose()) {
                    WalkModFacade.log.error((Object)("The system can't create the file [ " + this.cfg.getAbsolutePath() + "]"));
                }
                if (!this.options.isThrowException()) ** GOTO lbl30
                System.setProperty("user.dir", this.userDir);
                throw aux;
            }
        } else if (this.options.isVerbose()) {
            WalkModFacade.log.error((Object)("The configuration file [" + this.cfg.getAbsolutePath() + "] already exists"));
        }
lbl30:
        // 6 sources

        System.setProperty("user.dir", this.userDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChainConfig(ChainConfig chainCfg, boolean recursive, String before) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (!this.cfg.exists()) {
            this.init();
        }
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        try {
            ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
            ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
            cfgProvider.addChainConfig(chainCfg, recursive, before);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            System.setProperty("user.dir", this.userDir);
            this.updateMsg(startTime, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransformationConfig(String chain, String path, boolean recursive, TransformationConfig transformationCfg, Integer order, String before) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (!this.cfg.exists()) {
            this.init();
        }
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        try {
            ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
            ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
            cfgProvider.addTransformationConfig(chain, path, transformationCfg, recursive, order, before);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            System.setProperty("user.dir", this.userDir);
            this.updateMsg(startTime, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProviderConfig(ProviderConfig providerCfg, boolean recursive) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (!this.cfg.exists()) {
            this.init();
        }
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        try {
            ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
            ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
            cfgProvider.addProviderConfig(providerCfg, recursive);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            System.setProperty("user.dir", this.userDir);
            this.updateMsg(startTime, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginConfig(PluginConfig pluginConfig, boolean recursive) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (!this.cfg.exists()) {
            this.init();
        }
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        try {
            ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
            ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
            cfgProvider.addPluginConfig(pluginConfig, recursive);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            System.setProperty("user.dir", this.userDir);
            this.updateMsg(startTime, exception);
        }
    }

    private void updateMsg(long startTime, Exception e) {
        if (this.options.isVerbose()) {
            DecimalFormat myFormatter = new DecimalFormat("###.###");
            SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.US);
            long endTime = System.currentTimeMillis();
            double time = 0.0;
            if (endTime > startTime) {
                time = (double)(endTime - startTime) / 1000.0;
            }
            String timeMsg = myFormatter.format(time);
            System.out.print("----------------------------------------");
            System.out.println("----------------------------------------");
            if (e == null) {
                log.info((Object)"CONFIGURATION UPDATE SUCCESS");
            } else {
                log.info((Object)"CONFIGURATION UPDATE FAILS");
            }
            System.out.println();
            System.out.print("----------------------------------------");
            System.out.println("----------------------------------------");
            log.info((Object)("Total time: " + timeMsg + " seconds"));
            log.info((Object)("Finished at: " + df.format(new Date())));
            log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
            System.out.print("----------------------------------------");
            System.out.println("----------------------------------------");
            if (e != null) {
                if (this.options.isPrintErrors()) {
                    log.error((Object)"Plugin installations fails", (Throwable)e);
                } else {
                    log.info((Object)"Plugin installations fails. Please, execute walkmod with -e to see the details");
                }
                if (this.options.isThrowException()) {
                    RuntimeException re = new RuntimeException();
                    re.setStackTrace(e.getStackTrace());
                    throw re;
                }
            }
        }
    }

    public void install() throws InvalidConfigurationException {
        if (this.cfg.exists()) {
            long startTime;
            if (this.options.isVerbose()) {
                log.info((Object)(this.cfg.getAbsoluteFile() + " [ok]"));
            }
            IvyConfigurationProvider cp = new IvyConfigurationProvider(this.options.isOffline());
            if (this.options.isVerbose()) {
                log.info((Object)"** THE PLUGIN INSTALLATION STARTS **");
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
            }
            long endTime = startTime = System.currentTimeMillis();
            DecimalFormat myFormatter = new DecimalFormat("###.###");
            SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.US);
            boolean error = false;
            try {
                this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
                System.setProperty("user.dir", this.options.getExecutionDirectory().getCanonicalPath());
                ConfigurationManager cfgManager = new ConfigurationManager(this.cfg, cp);
                Configuration cf = cfgManager.getConfiguration();
                List<String> modules = cf.getModules();
                if (modules != null && !modules.isEmpty()) {
                    for (String module : modules) {
                        File aux = new File(module).getAbsoluteFile();
                        if (aux.isDirectory()) {
                            if (this.options.isVerbose()) {
                                log.info((Object)("** MODULE " + aux.getAbsoluteFile() + " [ok] **"));
                            }
                            WalkModFacade facade = new WalkModFacade(null, OptionsBuilder.options(this.options.asMap()).executionDirectory(aux), null);
                            facade.install();
                            continue;
                        }
                        log.error((Object)("The module " + aux.getAbsolutePath() + " is not an existing directory"));
                    }
                }
            }
            catch (Exception e) {
                System.setProperty("user.dir", this.userDir);
                if (this.options.isVerbose()) {
                    error = true;
                    endTime = System.currentTimeMillis();
                    double time = 0.0;
                    if (endTime > startTime) {
                        time = (double)(endTime - startTime) / 1000.0;
                    }
                    String timeMsg = myFormatter.format(time);
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)"PLUGIN INSTALLATION FAILS");
                    System.out.println();
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)("Total time: " + timeMsg + " seconds"));
                    log.info((Object)("Finished at: " + df.format(new Date())));
                    log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    if (this.options.isPrintErrors()) {
                        log.error((Object)"Plugin installations fails", (Throwable)e);
                    } else {
                        log.info((Object)"Plugin installations fails. Please, execute walkmod with -e to see the details");
                    }
                    if (this.options.isThrowException()) {
                        RuntimeException re = new RuntimeException();
                        re.setStackTrace(e.getStackTrace());
                        throw re;
                    }
                }
                throw new InvalidConfigurationException(e);
            }
            if (!error) {
                System.setProperty("user.dir", this.userDir);
                if (this.options.isVerbose()) {
                    endTime = System.currentTimeMillis();
                    double time = 0.0;
                    if (endTime > startTime) {
                        time = (double)(endTime - startTime) / 1000.0;
                    }
                    String timeMsg = myFormatter.format(time);
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    System.out.println();
                    log.info((Object)"PLUGIN INSTALLATION COMPLETE");
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)("Total time: " + timeMsg + " seconds"));
                    log.info((Object)("Finished at: " + df.format(new Date())));
                    log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                }
            }
        } else if (this.options.isVerbose()) {
            log.error((Object)(this.cfg.getAbsolutePath() + " does not exist. The root directory of your project must contain a walkmod.xml"));
        } else {
            throw new WalkModException(this.cfg.getAbsolutePath() + " does not exist. The root directory of your project must contain a walkmod.xml");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModules(List<String> modules) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (modules != null) {
            if (!this.cfg.exists()) {
                this.init();
            }
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
                cfgProvider.addModules(modules);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                System.setProperty("user.dir", this.userDir);
                this.updateMsg(startTime, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransformations(String chain, List<String> transformations, boolean recursive) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (transformations != null) {
            if (!this.cfg.exists()) {
                this.init();
            }
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
                cfgProvider.removeTransformations(chain, transformations, recursive);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                System.setProperty("user.dir", this.userDir);
                this.updateMsg(startTime, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriter(String chain, String type, String path, boolean recursive, Map<String, String> params) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (type != null && !"".equals(type.trim()) || path != null && !"".equals(path.trim())) {
            if (!this.cfg.exists()) {
                this.init();
            }
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
                cfgProvider.setWriter(chain, type, path, recursive, params);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                System.setProperty("user.dir", this.userDir);
                this.updateMsg(startTime, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReader(String chain, String type, String path, boolean recursive, Map<String, String> params) throws Exception {
        if (type != null && !"".equals(type.trim()) || path != null && !"".equals(path.trim())) {
            long startTime = System.currentTimeMillis();
            Exception exception = null;
            if (!this.cfg.exists()) {
                this.init();
            }
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
                cfgProvider.setReader(chain, type, path, recursive, params);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                System.setProperty("user.dir", this.userDir);
                this.updateMsg(startTime, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePluginConfig(PluginConfig pluginConfig, boolean recursive) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (!this.cfg.exists()) {
            this.init();
        }
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        try {
            ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
            ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
            cfgProvider.removePluginConfig(pluginConfig, recursive);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            System.setProperty("user.dir", this.userDir);
            this.updateMsg(startTime, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModules(List<String> modules) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (!this.cfg.exists()) {
            this.init();
        }
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        try {
            ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
            ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
            cfgProvider.removeModules(modules);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            System.setProperty("user.dir", this.userDir);
            this.updateMsg(startTime, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProviders(List<String> providers, boolean recursive) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (!this.cfg.exists()) {
            this.init();
        }
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        try {
            ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
            ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
            cfgProvider.removeProviders(providers, recursive);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            System.setProperty("user.dir", this.userDir);
            this.updateMsg(startTime, exception);
        }
    }

    public Configuration getConfiguration() throws Exception {
        Configuration result = null;
        if (this.cfg.exists()) {
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                manager.executeConfigurationProviders();
                result = manager.getConfiguration();
            }
            finally {
                System.setProperty("user.dir", this.userDir);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChains(List<String> chains, boolean recursive) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (this.cfg.exists()) {
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                manager.getProjectConfigurationProvider().removeChains(chains, recursive);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                System.setProperty("user.dir", this.userDir);
                this.updateMsg(startTime, exception);
            }
        }
    }

    public List<BeanDefinition> inspectPlugin(PluginConfig plugin) {
        ConfigurationImpl conf = new ConfigurationImpl();
        LinkedList<PluginConfig> plugins = new LinkedList<PluginConfig>();
        plugins.add(plugin);
        conf.setPlugins(plugins);
        ConfigurationManager manager = new ConfigurationManager((Configuration)conf, false, this.locateConfigurationProvider());
        manager.executeConfigurationProviders();
        return conf.getAvailableBeans(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurationParameter(String param, String value, String type, String category, String name, String chain, boolean recursive) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (this.cfg.exists()) {
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                manager.getProjectConfigurationProvider().addConfigurationParameter(param, value, type, category, name, chain, recursive);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                System.setProperty("user.dir", this.userDir);
                this.updateMsg(startTime, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncludesToChain(String chain, List<String> includes, boolean recursive, boolean setToReader, boolean setToWriter) {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (this.cfg.exists()) {
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                manager.getProjectConfigurationProvider().addIncludesToChain(chain, includes, recursive, setToReader, setToWriter);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                System.setProperty("user.dir", this.userDir);
                this.updateMsg(startTime, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExcludesToChain(String chain, List<String> excludes, boolean recursive, boolean setToReader, boolean setToWriter) {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (this.cfg.exists()) {
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                manager.getProjectConfigurationProvider().addExcludesToChain(chain, excludes, recursive, setToReader, setToWriter);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                System.setProperty("user.dir", this.userDir);
                this.updateMsg(startTime, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExcludesToChain(String chain, List<String> excludes, boolean recursive, boolean setToReader, boolean setToWriter) {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (this.cfg.exists()) {
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                manager.getProjectConfigurationProvider().removeExcludesFromChain(chain, excludes, recursive, setToReader, setToWriter);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                System.setProperty("user.dir", this.userDir);
                this.updateMsg(startTime, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIncludesToChain(String chain, List<String> includes, boolean recursive, boolean setToReader, boolean setToWriter) {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (this.cfg.exists()) {
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                manager.getProjectConfigurationProvider().removeIncludesFromChain(chain, includes, recursive, setToReader, setToWriter);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                System.setProperty("user.dir", this.userDir);
                this.updateMsg(startTime, exception);
            }
        }
    }
}

