/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Options {
    public static final String OFFLINE = "offline";
    public static final String VERBOSE = "verbose";
    public static final String PRINT_ERRORS = "print_errors";
    public static final String THROW_EXCEPTION = "throw_exception";
    public static final String INCLUDES = "includes";
    public static final String EXCLUDES = "excludes";
    public static final String EXECUTION_DIRECTORY = "execution_directory";
    public static final String CONFIGURATION_FILE_FORMAT = "format";
    public static final String DYNAMIC_ARGS = "dynamic_args";
    public static final String CHAIN_PATH = "chain_path";
    private Map<String, Object> options = new HashMap<String, Object>();

    public Options() {
        this(null);
    }

    public Options(Map<String, Object> options) {
        if (options != null) {
            this.options.putAll(options);
            if (!options.containsKey(OFFLINE)) {
                this.setOffline(false);
            }
            if (!options.containsKey(VERBOSE)) {
                this.setVerbose(true);
            }
            if (!options.containsKey(PRINT_ERRORS)) {
                this.setPrintErrors(false);
            }
            if (!options.containsKey(THROW_EXCEPTION)) {
                this.setThrowException(false);
            }
            if (!options.containsKey(EXECUTION_DIRECTORY)) {
                this.setExecutionDirectory(new File(System.getProperty("user.dir")));
            }
            if (!options.containsKey(CONFIGURATION_FILE_FORMAT)) {
                this.setConfigurationFormat("xml");
            }
        } else {
            this.setOffline(false);
            this.setVerbose(true);
            this.setPrintErrors(false);
            this.setThrowException(false);
            this.setExecutionDirectory(new File(System.getProperty("user.dir")));
            this.setConfigurationFormat("xml");
        }
    }

    public void setConfigurationFormat(String format) {
        String aux = format.toLowerCase().trim();
        if (aux.equals("yaml") || aux.equals("json")) {
            aux = "yml";
        }
        if (!aux.equals("xml") && !aux.equals("yml")) {
            throw new IllegalArgumentException("The configuration format " + aux + " is not supported");
        }
        this.options.put(CONFIGURATION_FILE_FORMAT, aux);
    }

    public String getConfigurationFormat() {
        Object value = this.options.get(CONFIGURATION_FILE_FORMAT);
        if (value == null) {
            value = "xml";
        }
        return value.toString();
    }

    public void setOffline(boolean offline) {
        this.options.put(OFFLINE, offline);
    }

    public boolean isOffline() {
        Object value = this.options.get(OFFLINE);
        return value != null && (Boolean)value != false;
    }

    public String getPath() {
        Object path = this.options.get(CHAIN_PATH);
        if (path != null) {
            return path.toString();
        }
        return null;
    }

    public void setPath(String path) {
        this.options.put(CHAIN_PATH, path);
    }

    public void setVerbose(boolean verbose) {
        this.options.put(VERBOSE, verbose);
    }

    public boolean isVerbose() {
        Object value = this.options.get(VERBOSE);
        return value != null && (Boolean)value != false;
    }

    public void setPrintErrors(boolean printErrors) {
        this.options.put(PRINT_ERRORS, printErrors);
    }

    public void setExecutionDirectory(File executionDirectory) {
        this.options.put(EXECUTION_DIRECTORY, executionDirectory);
    }

    public void setDynamicArgs(Map<String, Object> dynamicArgs) {
        this.options.put(DYNAMIC_ARGS, dynamicArgs);
    }

    public Map<String, Object> getDynamicArgs() {
        Object value = this.options.get(DYNAMIC_ARGS);
        return (Map)value;
    }

    public File getExecutionDirectory() {
        return (File)this.options.get(EXECUTION_DIRECTORY);
    }

    public boolean isPrintErrors() {
        Object value = this.options.get(PRINT_ERRORS);
        return value != null && (Boolean)value != false;
    }

    public void setThrowException(boolean throwException) {
        this.options.put(THROW_EXCEPTION, throwException);
    }

    public boolean isThrowException() {
        Object value = this.options.get(THROW_EXCEPTION);
        return value != null && (Boolean)value != false;
    }

    public void setIncludes(String ... includes) {
        if (includes != null) {
            if (!this.options.containsKey(INCLUDES)) {
                this.options.put(INCLUDES, new ArrayList());
            }
            List allIncludes = (List)this.options.get(INCLUDES);
            allIncludes.addAll(Arrays.asList(includes));
        }
    }

    public void setExcludes(String ... excludes) {
        if (excludes != null) {
            if (!this.options.containsKey(EXCLUDES)) {
                this.options.put(EXCLUDES, new ArrayList());
            }
            List allIncludes = (List)this.options.get(EXCLUDES);
            allIncludes.addAll(Arrays.asList(excludes));
        }
    }

    public List<String> getExcludes() {
        if (this.options.containsKey(EXCLUDES)) {
            return (List)this.options.get(EXCLUDES);
        }
        return null;
    }

    public List<String> getIncludes() {
        if (this.options.containsKey(INCLUDES)) {
            return (List)this.options.get(INCLUDES);
        }
        return null;
    }

    public Map<String, Object> asMap() {
        return this.options;
    }
}

