/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.util;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.walkmod.Resource;

public class FileResource
implements Resource<File> {
    private File file;
    private String[] extensions;
    private String[] includes;
    private String[] excludes;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) throws Exception {
        this.file = file.getCanonicalFile();
    }

    public void setPath(String path) throws Exception {
        File f = new File(path);
        this.setFile(f);
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    private static String[] toSuffixes(String[] extensions) {
        String[] suffixes = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            suffixes[i] = "." + extensions[i];
        }
        return suffixes;
    }

    private boolean matches(String fileName, String filter) {
        return filter.startsWith(fileName) || FilenameUtils.wildcardMatch((String)fileName, (String)filter) || fileName.startsWith(filter);
    }

    @Override
    public Iterator<File> iterator() {
        int i;
        String fileNormalized = FilenameUtils.normalize((String)this.file.getAbsolutePath(), (boolean)true);
        if (this.includes != null) {
            for (i = 0; i < this.includes.length; ++i) {
                if (!this.includes[i].startsWith(fileNormalized)) {
                    this.includes[i] = fileNormalized + "/" + this.includes[i];
                }
                if (!this.includes[i].endsWith("**")) continue;
                this.includes[i] = this.includes[i].substring(0, this.includes[i].length() - 3);
            }
        }
        if (this.excludes != null) {
            for (i = 0; i < this.excludes.length; ++i) {
                if (!this.excludes[i].startsWith(fileNormalized)) {
                    this.excludes[i] = fileNormalized + "/" + this.excludes[i];
                }
                if (!this.excludes[i].endsWith("**")) continue;
                this.excludes[i] = this.excludes[i].substring(0, this.excludes[i].length() - 3);
            }
        }
        if (this.file.isDirectory()) {
            IOFileFilter filter = null;
            IOFileFilter directoryFilter = TrueFileFilter.INSTANCE;
            if (this.excludes != null || this.includes != null) {
                directoryFilter = new IOFileFilter(){

                    public boolean accept(File dir, String name) {
                        int i;
                        boolean excludesEval = false;
                        boolean includesEval = false;
                        String aux = FilenameUtils.normalize((String)name, (boolean)true);
                        if (FileResource.this.excludes != null) {
                            for (i = 0; i < FileResource.this.excludes.length && !excludesEval; ++i) {
                                excludesEval = FilenameUtils.wildcardMatch((String)aux, (String)FileResource.this.excludes[i]) || dir.getAbsolutePath().startsWith(FileResource.this.excludes[i]);
                            }
                        }
                        if (FileResource.this.includes != null) {
                            for (i = 0; i < FileResource.this.includes.length && !includesEval; ++i) {
                                includesEval = FileResource.this.matches(aux, FileResource.this.includes[i]);
                            }
                        } else {
                            includesEval = true;
                        }
                        return includesEval && !excludesEval || FileResource.this.includes == null && FileResource.this.excludes == null;
                    }

                    public boolean accept(File file) {
                        int i;
                        boolean excludesEval = false;
                        boolean includesEval = false;
                        String aux = FilenameUtils.normalize((String)file.getAbsolutePath(), (boolean)true);
                        if (FileResource.this.excludes != null) {
                            for (i = 0; i < FileResource.this.excludes.length && !excludesEval; ++i) {
                                excludesEval = FilenameUtils.wildcardMatch((String)aux, (String)FileResource.this.excludes[i]) || file.getParentFile().getAbsolutePath().startsWith(FileResource.this.excludes[i]);
                            }
                        }
                        if (FileResource.this.includes != null) {
                            for (i = 0; i < FileResource.this.includes.length && !includesEval; ++i) {
                                includesEval = FileResource.this.matches(aux, FileResource.this.includes[i]);
                            }
                        } else {
                            includesEval = true;
                        }
                        boolean result = includesEval && !excludesEval || FileResource.this.includes == null && FileResource.this.excludes == null;
                        return result;
                    }
                };
                if (this.extensions == null) {
                    filter = directoryFilter;
                } else {
                    String[] suffixes = FileResource.toSuffixes(this.extensions);
                    filter = new SuffixFileFilter(suffixes);
                }
            } else if (this.extensions == null) {
                filter = TrueFileFilter.INSTANCE;
            } else {
                String[] suffixes = FileResource.toSuffixes(this.extensions);
                filter = new SuffixFileFilter(suffixes);
            }
            return FileUtils.listFiles((File)this.file, (IOFileFilter)filter, (IOFileFilter)directoryFilter).iterator();
        }
        LinkedList<File> aux = new LinkedList<File>();
        if (this.extensions == null) {
            aux.add(this.file);
        }
        return aux.iterator();
    }

    @Override
    public String getNearestNamespace(Object element, String regexSeparator) {
        if (element instanceof File) {
            return ((File)element).getParentFile().getPath().replaceAll("/", regexSeparator);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getOwnerNamespace(Object element, String regexSeparator) {
        if (element instanceof File) {
            return ((File)element).getParent().replaceAll("/", regexSeparator);
        }
        throw new IllegalArgumentException();
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String[] includes) {
        if (includes != null && System.getProperty("os.name").toLowerCase().contains("windows")) {
            for (int i = 0; i < includes.length; ++i) {
                includes[i] = FilenameUtils.normalize((String)includes[i], (boolean)true);
            }
        }
        this.includes = includes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] excludes) {
        if (excludes != null && System.getProperty("os.name").toLowerCase().contains("windows")) {
            for (int i = 0; i < excludes.length; ++i) {
                excludes[i] = FilenameUtils.normalize((String)excludes[i], (boolean)true);
            }
        }
        this.excludes = excludes;
    }
}

