/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.templates;

import groovy.io.PlatformLineWriter;
import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.walkmod.ChainWriter;
import org.walkmod.conf.entities.WriterConfig;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.templates.TemplateEngine;
import org.walkmod.templates.TemplatesAware;
import org.walkmod.walkers.ParseException;
import org.walkmod.walkers.Parser;
import org.walkmod.walkers.ParserAware;
import org.walkmod.walkers.VisitorContext;

public class DefaultTemplateVisitor
implements TemplatesAware,
ParserAware {
    private List<String> templates;
    private List<File> templateFiles;
    private List<String> missingTemplates = new LinkedList<String>();
    private File propertiesFile = null;
    private TemplateEngine templateEngine;
    private String rootLabel = null;
    private String output;
    private Parser<?> parser;
    private static Logger log = Logger.getLogger(DefaultTemplateVisitor.class);
    private File currentTemplate;
    private String suffix = ".result";

    public DefaultTemplateVisitor() {
    }

    public DefaultTemplateVisitor(TemplateEngine engine) {
        this.setTemplateEngine(engine);
    }

    public synchronized void visit(Object node, VisitorContext context) throws Exception {
        if (this.rootLabel == null) {
            this.setRootLabel("cu");
        }
        if (this.propertiesFile == null) {
            this.setProperties("template.properties");
        }
        context.put(this.getRootLabel(), node);
        if (this.templateEngine == null) {
            Object bean = context.getBean("org.walkmod.templates.groovy.GroovyTemplateEngine", null);
            if (bean != null && bean instanceof TemplateEngine) {
                this.templateEngine = (TemplateEngine)bean;
                log.info((Object)"Applying [groovy] as a default template engine");
            } else {
                throw new WalkModException("Template engine not found");
            }
        }
        this.templateEngine.initialize(context, node);
        if (this.templateFiles != null && this.templates != null && this.templateFiles.size() == this.templates.size()) {
            for (File template : this.templateFiles) {
                String templateResult = this.templateEngine.applyTemplate(template, this.propertiesFile);
                Object producedNode = null;
                this.currentTemplate = template;
                if (this.parser != null) {
                    try {
                        producedNode = this.parser.parse(templateResult, true);
                    }
                    catch (ParseException e) {
                        log.warn((Object)("Error parsing the template " + template.getAbsolutePath() + ". Dumping contents.."));
                        this.doPlainOutput(templateResult, context);
                    }
                } else {
                    this.doPlainOutput(templateResult, context);
                }
                if (producedNode == null) continue;
                log.debug((Object)"Template successfuly parsed");
                context.addResultNode(producedNode);
            }
        } else {
            if (!this.missingTemplates.isEmpty()) {
                for (String missing : this.missingTemplates) {
                    log.error((Object)("The template " + missing + " is missing"));
                }
            }
            throw new WalkModException("There are missing or unexitent templates.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSuffix(String suffix) {
        if (suffix == null) return;
        if ((suffix = suffix.trim()).startsWith(".")) {
            if (suffix.length() <= 1) throw new IllegalArgumentException("The suffix must have at least one letter");
            suffix = suffix.substring(1);
        } else if ("".equals(suffix)) {
            throw new IllegalArgumentException("The suffix must have at least one letter");
        }
        this.suffix = suffix;
    }

    public void doPlainOutput(String templateResult, VisitorContext context) throws Exception {
        WriterConfig writerConfig = context.getArchitectureConfig().getWriterConfig();
        ChainWriter chainWriter = writerConfig.getModelWriter();
        if (this.output == null) {
            String fileName = this.currentTemplate.getName();
            if (context.containsKey("original_file_key")) {
                log.debug((Object)"Original file path found");
                File originalFile = (File)context.get("original_file_key");
                String fullPath = originalFile.getPath();
                String readerPath = context.getArchitectureConfig().getReaderConfig().getPath();
                fileName = fullPath.substring(readerPath.length());
                if (fileName.startsWith(File.separator)) {
                    fileName = fileName.substring(1);
                }
            } else {
                log.debug((Object)"working with the template name");
            }
            int pos = fileName.lastIndexOf(".");
            if (pos != -1) {
                log.debug((Object)"Removing the existing suffix");
                fileName = fileName.substring(0, pos);
            }
            log.warn((Object)("Setting a default output file! [" + fileName + ".result]"));
            VisitorContext auxCtxt = new VisitorContext();
            File defaultOutputFile = new File(writerConfig.getPath(), fileName + "." + this.suffix);
            if (!defaultOutputFile.exists()) {
                log.info((Object)("++" + defaultOutputFile.getAbsolutePath()));
                defaultOutputFile.getParentFile().mkdirs();
                defaultOutputFile.createNewFile();
            }
            auxCtxt.put("original_file_key", (Object)defaultOutputFile);
            chainWriter.write(templateResult, auxCtxt);
        } else {
            String outputFile = this.output;
            char[] chars = outputFile.toCharArray();
            boolean isGString = false;
            for (int i = 0; i < chars.length && !isGString; ++i) {
                isGString = chars[i] == '$' || chars[i] == '<';
            }
            if (isGString) {
                GStringTemplateEngine engine = new GStringTemplateEngine();
                Template templateName = engine.createTemplate(this.output);
                StringWriter stringWriter = new StringWriter();
                PlatformLineWriter platformWriter = new PlatformLineWriter((Writer)stringWriter);
                templateName.make((Map)context).writeTo((Writer)platformWriter);
                outputFile = platformWriter.toString();
            }
            File file = new File(outputFile);
            VisitorContext auxCtxt = new VisitorContext();
            auxCtxt.put("original_file_key", (Object)file);
            auxCtxt.put("append", (Object)Boolean.TRUE);
            if (!file.exists()) {
                log.info((Object)("++" + file.getAbsolutePath()));
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            chainWriter.write(templateResult, auxCtxt);
        }
    }

    @Override
    public List<String> getTemplates() {
        return this.templates;
    }

    @Override
    public void setTemplates(List<String> templates) {
        this.templates = templates;
        if (templates != null) {
            this.templateFiles = new LinkedList<File>();
            for (String template : templates) {
                File aux = new File(template);
                if (aux.exists()) {
                    this.templateFiles.add(aux);
                    continue;
                }
                this.missingTemplates.add(template);
            }
        }
    }

    @Override
    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    @Override
    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    @Override
    public String getRootLabel() {
        return this.rootLabel;
    }

    @Override
    public void setRootLabel(String rootLabel) {
        this.rootLabel = rootLabel;
    }

    public void setProperties(String propertiesFile) {
        File properties = new File(propertiesFile);
        if (properties.exists()) {
            this.propertiesFile = properties;
        }
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getOutput() {
        return this.output;
    }

    @Override
    public void setParser(Parser<?> parser) {
        this.parser = parser;
    }

    @Override
    public Parser<?> getParser() {
        return this.parser;
    }
}

