/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.walkmod.ConfigurationAdapter;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.MergePolicyConfig;
import org.walkmod.conf.entities.ProviderConfig;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.merger.MergeEngine;
import org.walkmod.merger.MergePolicy;

public class DefaultConfigurationAdapter
implements ConfigurationAdapter {
    private Configuration config;

    @Override
    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public void prepare() {
        Collection<MergePolicyConfig> mergePolicies;
        Collection<ProviderConfig> providers = this.config.getProviderConfigurations();
        if (providers != null) {
            for (ProviderConfig pc : providers) {
                Object aux = this.config.getBean(pc.getType(), pc.getParameters());
                if (!(aux instanceof ConfigurationProvider)) continue;
                ConfigurationProvider cp = (ConfigurationProvider)aux;
                cp.init(this.config);
                cp.load();
            }
        }
        if ((mergePolicies = this.config.getMergePolicies()) != null) {
            HashMap<String, MergeEngine> mergeEngines = new HashMap<String, MergeEngine>();
            this.config.setMergeEngines(mergeEngines);
            for (MergePolicyConfig mpc : mergePolicies) {
                String topTypeLabel;
                MergeEngine me = new MergeEngine();
                mergeEngines.put(mpc.getName(), me);
                String dopTypeLabel = mpc.getDefaultObjectPolicy();
                Object dop = null;
                Object top = null;
                if (dopTypeLabel != null) {
                    dop = this.config.getBean(dopTypeLabel, null);
                }
                if (dop != null && dop instanceof MergePolicy) {
                    me.setDefaultObjectMergePolicy((MergePolicy)dop);
                }
                if ((topTypeLabel = mpc.getDefaultTypePolicy()) != null) {
                    top = this.config.getBean(topTypeLabel, null);
                }
                if (top != null && top instanceof MergePolicy) {
                    me.setDefaultTypeMergePolicy((MergePolicy)top);
                }
                Map<String, String> policyEntries = mpc.getPolicyEntries();
                Class<?> oType = null;
                Object pType = null;
                HashMap resolvedEntries = new HashMap();
                if (policyEntries != null && !policyEntries.isEmpty()) {
                    for (Map.Entry<String, String> entry : policyEntries.entrySet()) {
                        try {
                            oType = this.config.getClassLoader().loadClass(entry.getKey());
                        }
                        catch (ClassNotFoundException e) {
                            throw new WalkModException("Invalid policy entry for " + entry.getKey());
                        }
                        pType = this.config.getBean(entry.getValue(), null);
                        if (!(pType instanceof MergePolicy)) continue;
                        resolvedEntries.put(oType, (MergePolicy)pType);
                    }
                }
                me.setPolicyConfiguration(resolvedEntries);
            }
        }
    }
}

