/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.yml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Iterator;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.YAMLConfigurationProvider;
import org.walkmod.conf.providers.yml.AbstractYMLConfigurationAction;

public class SetReaderYMLAction
extends AbstractYMLConfigurationAction {
    private String chain;
    private String type;
    private String path;

    public SetReaderYMLAction(String chain, String type, String path, YAMLConfigurationProvider provider, boolean recursive) {
        super(provider, recursive);
        this.chain = chain;
        this.type = type;
        this.path = path;
    }

    @Override
    public void doAction(JsonNode node) throws Exception {
        if (node.has("chains") && (this.chain == null || "".equals(this.chain.trim()))) {
            this.chain = "default";
        }
        ObjectNode reader = null;
        ObjectMapper mapper = this.provider.getObjectMapper();
        if (this.chain != null && !"".equals(this.chain.trim())) {
            JsonNode chainsListNode;
            if (node.has("chains") && (chainsListNode = node.get("chains")).isArray()) {
                Iterator it = chainsListNode.iterator();
                boolean found = false;
                while (it.hasNext() && !found) {
                    String name;
                    JsonNode current = (JsonNode)it.next();
                    if (!current.has("name") || !(found = (name = current.get("name").asText()).equals(this.chain))) continue;
                    reader = current.has("reader") ? (ObjectNode)current.get("reader") : new ObjectNode(mapper.getNodeFactory());
                    if (this.type != null && !"".equals(this.type.trim())) {
                        reader.set("type", (JsonNode)new TextNode(this.type));
                    }
                    if (this.path == null || "".equals(this.path.trim())) continue;
                    reader.set("path", (JsonNode)new TextNode(this.path));
                }
            }
            if (reader != null) {
                this.provider.write(node);
            }
        } else if (!node.has("chains")) {
            ArrayNode chains = new ArrayNode(mapper.getNodeFactory());
            ObjectNode defaultChain = new ObjectNode(mapper.getNodeFactory());
            defaultChain.set("name", (JsonNode)new TextNode("default"));
            ObjectNode readerNode = new ObjectNode(mapper.getNodeFactory());
            if (this.type != null && !"".equals(this.type.trim())) {
                readerNode.set("type", (JsonNode)new TextNode(this.type));
            }
            if (this.path != null && !"".equals(this.path.trim())) {
                readerNode.set("path", (JsonNode)new TextNode(this.path));
            }
            defaultChain.set("reader", (JsonNode)readerNode);
            if (node.has("transformations")) {
                defaultChain.set("transformations", node.get("transformations"));
            }
            chains.add((JsonNode)defaultChain);
            this.provider.write((JsonNode)chains);
        }
    }

    @Override
    public AbstractYMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new SetReaderYMLAction(this.chain, this.type, this.path, (YAMLConfigurationProvider)provider, recursive);
    }
}

