/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.yml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.List;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.YAMLConfigurationProvider;
import org.walkmod.conf.providers.yml.AbstractYMLConfigurationAction;

public class RemoveModulesYMLAction
extends AbstractYMLConfigurationAction {
    private List<String> modules;

    public RemoveModulesYMLAction(List<String> modules, YAMLConfigurationProvider provider) {
        super(provider, false);
        this.modules = modules;
    }

    @Override
    public void doAction(JsonNode node) throws Exception {
        if (node.has("modules")) {
            JsonNode aux = node.get("modules");
            ObjectMapper mapper = this.provider.getObjectMapper();
            if (aux.isArray()) {
                ArrayNode modulesList = (ArrayNode)node.get("modules");
                Iterator it = modulesList.iterator();
                ArrayNode newModulesList = new ArrayNode(mapper.getNodeFactory());
                while (it.hasNext()) {
                    String text;
                    JsonNode next = (JsonNode)it.next();
                    if (!next.isTextual() || this.modules.contains(text = next.asText())) continue;
                    newModulesList.add(text);
                }
                ObjectNode oNode = (ObjectNode)node;
                if (newModulesList.size() > 0) {
                    oNode.set("modules", (JsonNode)newModulesList);
                } else {
                    oNode.remove("modules");
                }
                this.provider.write(node);
            }
        }
    }

    @Override
    public AbstractYMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new RemoveModulesYMLAction(this.modules, (YAMLConfigurationProvider)provider);
    }
}

