/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.yml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Iterator;
import java.util.LinkedList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.TransformationConfig;
import org.walkmod.conf.entities.impl.ChainConfigImpl;
import org.walkmod.conf.entities.impl.WalkerConfigImpl;
import org.walkmod.conf.providers.YAMLConfigurationProvider;
import org.walkmod.conf.providers.yml.AbstractYMLConfigurationAction;

public class AddTransformationYMLAction
extends AbstractYMLConfigurationAction {
    private String chain;
    private String path;
    private TransformationConfig transformationCfg;

    public AddTransformationYMLAction(String chain, String path, TransformationConfig transformationCfg, YAMLConfigurationProvider provider, boolean recursive) {
        super(provider, recursive);
        this.chain = chain;
        this.path = path;
        this.transformationCfg = transformationCfg;
    }

    @Override
    public void doAction(JsonNode chainsNode) throws Exception {
        ArrayNode transformationsNode = null;
        boolean isMultiModule = chainsNode.has("modules");
        ObjectMapper mapper = this.provider.getObjectMapper();
        if (!isMultiModule) {
            JsonNode aux;
            boolean validChainName;
            boolean bl = validChainName = this.chain != null && !"".equals(this.chain) && !"default".equals(this.chain);
            if (!chainsNode.has("chains")) {
                if (chainsNode.has("transformations")) {
                    aux = chainsNode.get("transformations");
                    if (aux.isArray()) {
                        transformationsNode = (ArrayNode)aux;
                    }
                    if (!validChainName) {
                        ObjectNode auxRoot = (ObjectNode)chainsNode;
                        if (transformationsNode == null) {
                            transformationsNode = new ArrayNode(mapper.getNodeFactory());
                        }
                        auxRoot.set("transformations", (JsonNode)transformationsNode);
                    } else {
                        chainsNode = new ObjectNode(mapper.getNodeFactory());
                        ObjectNode auxRoot = (ObjectNode)chainsNode;
                        ObjectNode chainObject = new ObjectNode(mapper.getNodeFactory());
                        chainObject.set("name", (JsonNode)new TextNode("default"));
                        chainObject.set("transformations", (JsonNode)transformationsNode);
                        ArrayNode chainsListNode = new ArrayNode(mapper.getNodeFactory());
                        chainsListNode.add((JsonNode)chainObject);
                        ObjectNode newChain = new ObjectNode(mapper.getNodeFactory());
                        newChain.set("name", (JsonNode)new TextNode(this.chain));
                        if (this.path != null && !"".equals(this.path.trim())) {
                            ObjectNode readerNode = new ObjectNode(mapper.getNodeFactory());
                            newChain.set("reader", (JsonNode)readerNode);
                            this.populateWriterReader(readerNode, this.path, null, null, null, null);
                            ObjectNode writerNode = new ObjectNode(mapper.getNodeFactory());
                            newChain.set("writer", (JsonNode)writerNode);
                            this.populateWriterReader(writerNode, this.path, null, null, null, null);
                        }
                        transformationsNode = new ArrayNode(mapper.getNodeFactory());
                        newChain.set("transformations", (JsonNode)transformationsNode);
                        chainsListNode.add((JsonNode)newChain);
                        auxRoot.set("chains", (JsonNode)chainsListNode);
                    }
                } else {
                    ObjectNode auxRoot = (ObjectNode)chainsNode;
                    transformationsNode = new ArrayNode(mapper.getNodeFactory());
                    boolean writeChainInfo = validChainName;
                    if (!writeChainInfo) {
                        writeChainInfo = this.path != null && !"".equals(this.path.trim());
                        this.chain = "default";
                    }
                    if (writeChainInfo) {
                        ArrayNode auxChainsList = new ArrayNode(mapper.getNodeFactory());
                        ObjectNode aux2 = new ObjectNode(mapper.getNodeFactory());
                        auxChainsList.add((JsonNode)aux2);
                        aux2.set("name", (JsonNode)new TextNode(this.chain));
                        if (this.path != null && !"".equals(this.path.trim())) {
                            ObjectNode readerNode = new ObjectNode(mapper.getNodeFactory());
                            aux2.set("reader", (JsonNode)readerNode);
                            this.populateWriterReader(readerNode, this.path, null, null, null, null);
                        }
                        auxRoot.set("chains", (JsonNode)auxChainsList);
                        if (this.path != null && !"".equals(this.path.trim())) {
                            ObjectNode writerNode = new ObjectNode(mapper.getNodeFactory());
                            aux2.set("writer", (JsonNode)writerNode);
                            this.populateWriterReader(writerNode, this.path, null, null, null, null);
                        }
                        auxRoot = aux2;
                    }
                    auxRoot.set("transformations", (JsonNode)transformationsNode);
                }
            } else if (validChainName) {
                aux = chainsNode.get("chains");
                boolean found = false;
                if (aux.isArray()) {
                    Iterator it = aux.elements();
                    while (it.hasNext()) {
                        String id;
                        JsonNode next = (JsonNode)it.next();
                        if (!next.has("name") || !this.chain.equals(id = next.get("name").asText())) continue;
                        found = true;
                        if (next.has("transformations")) {
                            JsonNode auxTrans = next.get("transformations");
                            if (auxTrans.isArray()) {
                                transformationsNode = (ArrayNode)auxTrans;
                                continue;
                            }
                            throw new Exception("The chain [" + this.chain + "] does not have a valid transformations node");
                        }
                        if (next.isObject()) {
                            ObjectNode auxNext = (ObjectNode)next;
                            transformationsNode = new ArrayNode(mapper.getNodeFactory());
                            auxNext.set("transformations", (JsonNode)transformationsNode);
                            continue;
                        }
                        throw new Exception("The chain [" + this.chain + "] does not have a valid structure");
                    }
                    if (!found) {
                        ChainConfigImpl chainCfg = new ChainConfigImpl();
                        chainCfg.setName(this.chain);
                        WalkerConfigImpl walkerCfg = new WalkerConfigImpl();
                        LinkedList<TransformationConfig> transfs = new LinkedList<TransformationConfig>();
                        transfs.add(this.transformationCfg);
                        walkerCfg.setTransformations(transfs);
                        chainCfg.setWalkerConfig(walkerCfg);
                        this.provider.addChainConfig(chainCfg, false);
                        return;
                    }
                }
            } else {
                throw new Exception("The user must specify a chain name (new or existing) where to add the transformation: [" + this.transformationCfg.getType() + "]");
            }
            if (transformationsNode != null) {
                ObjectNode transformationNode = new ObjectNode(mapper.getNodeFactory());
                transformationsNode.add((JsonNode)transformationNode);
                this.createTransformation(transformationNode, this.transformationCfg);
                this.provider.write(chainsNode);
                return;
            }
            if (this.chain != null) {
                throw new Exception("The chain [" + this.chain + "] does not exists");
            }
        }
    }

    @Override
    public AbstractYMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new AddTransformationYMLAction(this.chain, this.path, this.transformationCfg, (YAMLConfigurationProvider)provider, recursive);
    }
}

