/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.yml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.YAMLConfigurationProvider;
import org.walkmod.conf.providers.yml.AbstractYMLConfigurationAction;

public class AddModulesYMLAction
extends AbstractYMLConfigurationAction {
    private List<String> modules;

    public AddModulesYMLAction(List<String> modules, YAMLConfigurationProvider provider) {
        super(provider, false);
        this.modules = modules;
    }

    @Override
    public void doAction(JsonNode node) throws Exception {
        ArrayNode aux = null;
        HashSet<String> modulesToAdd = new HashSet<String>(this.modules);
        if (node.has("modules")) {
            JsonNode list = node.get("modules");
            Iterator it = list.iterator();
            while (it.hasNext()) {
                JsonNode next = (JsonNode)it.next();
                modulesToAdd.remove(next.asText().trim());
            }
            if (!modulesToAdd.isEmpty() && list.isArray()) {
                aux = (ArrayNode)list;
            }
        } else {
            aux = new ArrayNode(this.provider.getObjectMapper().getNodeFactory());
        }
        if (!modulesToAdd.isEmpty()) {
            for (String moduleToAdd : modulesToAdd) {
                TextNode prov = new TextNode(moduleToAdd);
                aux.add((JsonNode)prov);
            }
            ObjectNode auxNode = (ObjectNode)node;
            auxNode.set("modules", (JsonNode)aux);
            this.provider.write(node);
        }
    }

    @Override
    public AbstractYMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new AddModulesYMLAction(this.modules, (YAMLConfigurationProvider)provider);
    }
}

