/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.yml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.YAMLConfigurationProvider;
import org.walkmod.conf.providers.yml.AbstractYMLConfigurationAction;

public class AddConfigurationParameterYMLAction
extends AbstractYMLConfigurationAction {
    String param;
    String value;
    String type;
    String category;
    String name;
    String chain;

    public AddConfigurationParameterYMLAction(String param, String value, String type, String category, String name, String chain, YAMLConfigurationProvider provider, boolean recursive) {
        super(provider, recursive);
        this.param = param;
        this.value = value;
        this.type = type;
        this.category = category;
        this.name = name;
        this.chain = chain;
    }

    private void analyzeNode(JsonNode node, String type, String name, List<JsonNode> elementsToModify) {
        if (type != null && node.has("type") && node.get("type").textValue().equals(type)) {
            if (name != null && node.has("name")) {
                if (node.get("name").textValue().equals(name)) {
                    elementsToModify.add(node);
                }
            } else {
                elementsToModify.add(node);
            }
        }
    }

    @Override
    public void doAction(JsonNode node) throws Exception {
        JsonNode transformationsNode;
        LinkedList<JsonNode> elementsToModify = new LinkedList<JsonNode>();
        if (node.has("chains")) {
            JsonNode aux = node.get("chains");
            if (aux.isArray()) {
                ArrayNode chainsList = (ArrayNode)node.get("chains");
                for (JsonNode next : chainsList) {
                    JsonNode categoryNode;
                    JsonNode walkerNode = null;
                    JsonNode transformationsNode2 = null;
                    if (this.chain == null || this.chain.equals(next.get("name").asText())) {
                        if (this.category != null) {
                            if (node.has(this.category)) {
                                categoryNode = node.get(this.category);
                                this.analyzeNode(categoryNode, this.type, this.name, elementsToModify);
                            } else {
                                if (this.category.equals("transformation") && node.has("transformations")) {
                                    transformationsNode2 = node.get("transformations");
                                }
                                if (node.has("walker")) {
                                    walkerNode = node.get("walker");
                                }
                            }
                        } else {
                            Iterator it2 = next.iterator();
                            while (it2.hasNext()) {
                                this.analyzeNode((JsonNode)it2.next(), this.type, this.name, elementsToModify);
                            }
                            if (next.has("walker")) {
                                walkerNode = next.get("walker");
                            } else if (next.has("transformations")) {
                                transformationsNode2 = next.get("transformations");
                            }
                        }
                    }
                    if (walkerNode != null) {
                        if (this.category != null) {
                            if (walkerNode.has(this.category)) {
                                categoryNode = node.get(this.category);
                                this.analyzeNode(categoryNode, this.type, this.name, elementsToModify);
                            }
                        } else if (walkerNode.has("transformations")) {
                            transformationsNode2 = walkerNode.get("transformations");
                        }
                    }
                    if (transformationsNode2 == null || !transformationsNode2.isArray()) continue;
                    ArrayNode transformationsArray = (ArrayNode)transformationsNode2;
                    for (JsonNode current : transformationsArray) {
                        this.analyzeNode(current, this.type, this.name, elementsToModify);
                    }
                }
            }
        } else if (node.has("transformations") && (this.category == null || "transformation".equals(this.category)) && (transformationsNode = node.get("transformations")).isArray()) {
            ArrayNode transformationsArray = (ArrayNode)transformationsNode;
            for (JsonNode current : transformationsArray) {
                this.analyzeNode(current, this.type, this.name, elementsToModify);
            }
        }
        for (JsonNode current : elementsToModify) {
            if (!current.isObject()) continue;
            JsonNode params = null;
            if (current.has("params")) {
                params = current.get("params");
                if (!params.isObject()) continue;
                ((ObjectNode)params).set(this.param, (JsonNode)new TextNode(this.value));
                continue;
            }
            HashMap<String, Object> paramToAdd = new HashMap<String, Object>();
            paramToAdd.put(this.param, this.value);
            this.populateParams((ObjectNode)current, paramToAdd);
        }
        if (!elementsToModify.isEmpty()) {
            this.provider.write(node);
        }
    }

    @Override
    public AbstractYMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new AddConfigurationParameterYMLAction(this.param, this.value, this.type, this.category, this.name, this.chain, (YAMLConfigurationProvider)provider, recursive);
    }
}

