/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.yml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.TransformationConfig;
import org.walkmod.conf.providers.ConfigurationAction;
import org.walkmod.conf.providers.YAMLConfigurationProvider;

public abstract class AbstractYMLConfigurationAction
implements ConfigurationAction {
    protected YAMLConfigurationProvider provider;
    private boolean recursive;

    public AbstractYMLConfigurationAction(YAMLConfigurationProvider provider, boolean recursive) {
        this.provider = provider;
        this.recursive = recursive;
    }

    @Override
    public void execute() throws Exception {
        JsonNode node = this.provider.getRootNode();
        boolean isMultiModule = node.has("modules");
        if (this.recursive && isMultiModule) {
            JsonNode aux = node.get("modules");
            if (aux.isArray()) {
                ArrayNode modules = (ArrayNode)aux;
                int max = modules.size();
                for (int i = 0; i < max; ++i) {
                    JsonNode module = modules.get(i);
                    if (!module.isTextual()) continue;
                    String moduleDir = module.asText();
                    try {
                        File auxFile = new File(this.provider.getFileName()).getCanonicalFile().getParentFile();
                        YAMLConfigurationProvider child = new YAMLConfigurationProvider(auxFile.getAbsolutePath() + File.separator + moduleDir + File.separator + "walkmod.yml");
                        child.createConfig();
                        AbstractYMLConfigurationAction childAction = this.clone(child, this.recursive);
                        childAction.execute();
                        continue;
                    }
                    catch (IOException e) {
                        throw new TransformerException(e);
                    }
                }
            }
        } else {
            this.doAction(node);
        }
    }

    public void populateParams(ObjectNode root, Map<String, Object> params) {
        ObjectNode paramsNode = new ObjectNode(this.provider.getObjectMapper().getNodeFactory());
        root.set("params", (JsonNode)paramsNode);
        Set<String> keys = params.keySet();
        for (String key : keys) {
            paramsNode.set(key, (JsonNode)new TextNode(params.get(key).toString()));
        }
    }

    public void populateWriterReader(ObjectNode root, String path, String type, String[] includes, String[] excludes, Map<String, Object> params) {
        int i;
        if (path != null && !"".equals(path)) {
            root.set("path", (JsonNode)new TextNode(path));
        }
        if (type != null) {
            root.set("type", (JsonNode)new TextNode(type));
        }
        if (includes != null && includes.length > 0) {
            ArrayNode includesNode = new ArrayNode(this.provider.getObjectMapper().getNodeFactory());
            for (i = 0; i < includes.length; ++i) {
                includesNode.add((JsonNode)new TextNode(includes[i]));
            }
            root.set("includes", (JsonNode)includesNode);
        }
        if (excludes != null && excludes.length > 0) {
            ArrayNode excludesNode = new ArrayNode(this.provider.getObjectMapper().getNodeFactory());
            for (i = 0; i < excludes.length; ++i) {
                excludesNode.add((JsonNode)new TextNode(excludes[i]));
            }
            root.set("excludes", (JsonNode)excludesNode);
        }
        if (params != null && !params.isEmpty()) {
            this.populateParams(root, params);
        }
    }

    public void createTransformation(ObjectNode transformationNode, TransformationConfig transCfg) {
        Map<String, Object> params;
        String mergePolicy;
        String typeName;
        String name = transCfg.getName();
        if (name != null) {
            transformationNode.set("name", (JsonNode)new TextNode(name));
        }
        if ((typeName = transCfg.getType()) != null) {
            transformationNode.set("type", (JsonNode)new TextNode(typeName));
        }
        if ((mergePolicy = transCfg.getMergePolicy()) != null) {
            transformationNode.set("merge-policy", (JsonNode)new TextNode(mergePolicy));
        }
        if (transCfg.isMergeable()) {
            transformationNode.set("isMergeable", (JsonNode)BooleanNode.TRUE);
        }
        if ((params = transCfg.getParameters()) != null && !params.isEmpty()) {
            this.populateParams(transformationNode, params);
        }
    }

    public abstract void doAction(JsonNode var1) throws Exception;

    public abstract AbstractYMLConfigurationAction clone(ConfigurationProvider var1, boolean var2);
}

