/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.xml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.XMLConfigurationProvider;
import org.walkmod.conf.providers.xml.AbstractXMLConfigurationAction;

public class SetWriterXMLAction
extends AbstractXMLConfigurationAction {
    private String chain;
    private String type;
    private String path;

    public SetWriterXMLAction(String chain, String type, String path, XMLConfigurationProvider provider, boolean recursive) {
        super(provider, recursive);
        this.chain = chain;
        this.type = type;
        this.path = path;
    }

    @Override
    public void doAction() throws Exception {
        Document document = this.provider.getDocument();
        Element rootElement = document.getDocumentElement();
        Node writerParent = null;
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        Element child = null;
        for (int i = 0; i < childSize; ++i) {
            Node childNode = children.item(i);
            if (!(childNode instanceof Element)) continue;
            child = (Element)childNode;
            String nodeName = child.getNodeName();
            if ("chain".equals(nodeName)) {
                String name;
                if (!child.hasAttribute("name") || !(name = child.getAttribute("name")).equals(this.chain)) continue;
                writerParent = child;
                continue;
            }
            if (!"transformation".equals(nodeName) || this.chain != null && !"default".equals(this.chain)) continue;
            writerParent = rootElement;
        }
        if (writerParent == rootElement) {
            int i;
            Element chainElem = document.createElement("chain");
            rootElement.appendChild(chainElem);
            chainElem.setAttribute("name", "default");
            for (i = 0; i < childSize; ++i) {
                chainElem.appendChild(children.item(i).cloneNode(true));
            }
            for (i = 0; i < childSize; ++i) {
                rootElement.removeChild(children.item(i));
            }
            writerParent = chainElem;
        }
        if (writerParent != null) {
            NodeList siblings = writerParent.getChildNodes();
            int limit = siblings.getLength();
            boolean updated = false;
            for (int i = 0; i < limit && !updated; ++i) {
                Element aux;
                Node childNode = siblings.item(i);
                if (!(childNode instanceof Element) || !"writer".equals((aux = (Element)childNode).getNodeName())) continue;
                if (this.type != null && !"".equals(this.type.trim())) {
                    aux.setAttribute("type", this.type);
                }
                if (this.path != null && !"".equals(this.path.trim())) {
                    aux.setAttribute("path", this.path);
                }
                updated = true;
            }
            if (!updated) {
                Element writerElem = document.createElement("writer");
                if (this.type != null && !"".equals(this.type.trim())) {
                    writerElem.setAttribute("type", this.type);
                }
                if (this.path != null && !"".equals(this.path.trim())) {
                    writerElem.setAttribute("path", this.path);
                } else {
                    writerElem.setAttribute("path", "src/main/java");
                }
                writerParent.appendChild(writerElem);
            }
            this.provider.persist();
        }
    }

    @Override
    public AbstractXMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new SetWriterXMLAction(this.chain, this.type, this.path, (XMLConfigurationProvider)provider, recursive);
    }
}

