/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.xml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.XMLConfigurationProvider;
import org.walkmod.conf.providers.xml.AbstractXMLConfigurationAction;

public class SetReaderXMLAction
extends AbstractXMLConfigurationAction {
    private String chain;
    private String type;
    private String path;

    public SetReaderXMLAction(String chain, String type, String path, XMLConfigurationProvider provider, boolean recursive) {
        super(provider, recursive);
        this.chain = chain;
        this.type = type;
        this.path = path;
    }

    @Override
    public void doAction() throws Exception {
        Document document = this.provider.getDocument();
        Element rootElement = document.getDocumentElement();
        Node readerParent = null;
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        Element child = null;
        for (int i = 0; i < childSize; ++i) {
            Node childNode = children.item(i);
            if (!(childNode instanceof Element)) continue;
            child = (Element)childNode;
            String nodeName = child.getNodeName();
            if ("chain".equals(nodeName)) {
                String name;
                if (!child.hasAttribute("name") || !(name = child.getAttribute("name")).equals(this.chain)) continue;
                readerParent = child;
                continue;
            }
            if (!"transformation".equals(nodeName) || this.chain != null && !"default".equals(this.chain)) continue;
            readerParent = rootElement;
        }
        if (readerParent == rootElement) {
            document.removeChild(rootElement);
            Element chainElem = document.createElement("chain");
            document.appendChild(chainElem);
            chainElem.setAttribute("name", "default");
            for (int i = 0; i < childSize; ++i) {
                chainElem.appendChild(children.item(i));
            }
            readerParent = chainElem;
        }
        if (readerParent != null) {
            NodeList siblings = readerParent.getChildNodes();
            int limit = siblings.getLength();
            boolean updated = false;
            for (int i = 0; i < limit && !updated; ++i) {
                Element aux;
                Node childNode = siblings.item(i);
                if (!(childNode instanceof Element) || !"reader".equals((aux = (Element)childNode).getNodeName())) continue;
                if (this.type != null && !"".equals(this.type.trim())) {
                    aux.setAttribute("type", this.type);
                }
                if (this.path != null && !"".equals(this.path.trim())) {
                    aux.setAttribute("path", this.path);
                }
                updated = true;
            }
            if (!updated) {
                Element readerElement = document.createElement("reader");
                if (this.type != null && !"".equals(this.type.trim())) {
                    readerElement.setAttribute("type", this.type);
                }
                if (this.path != null && !"".equals(this.path.trim())) {
                    readerElement.setAttribute("path", this.path);
                } else {
                    readerElement.setAttribute("path", "src/main/java");
                }
                readerParent.insertBefore(readerElement, readerParent.getFirstChild());
            }
            this.provider.persist();
        }
    }

    @Override
    public AbstractXMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new SetReaderXMLAction(this.chain, this.type, this.path, (XMLConfigurationProvider)provider, recursive);
    }
}

