/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.xml;

import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.XMLConfigurationProvider;
import org.walkmod.conf.providers.xml.AbstractXMLConfigurationAction;

public class RemoveTransformationXMLAction
extends AbstractXMLConfigurationAction {
    private String chain;
    private List<String> transformations;

    public RemoveTransformationXMLAction(String chain, List<String> transformations, XMLConfigurationProvider provider, boolean recursive) {
        super(provider, recursive);
        this.chain = chain;
        this.transformations = transformations;
    }

    private boolean removeTransformation(Element rootNode, HashSet<String> transformations) {
        NodeList children = rootNode.getChildNodes();
        int childSize = children.getLength();
        Element child = null;
        boolean modified = false;
        for (int i = 0; i < childSize; ++i) {
            String type;
            int j;
            Node childNode = children.item(i);
            if (!(childNode instanceof Element)) continue;
            child = (Element)childNode;
            String nodeName = child.getNodeName();
            if ("transformations".equals(nodeName)) {
                NodeList transfNodeList = child.getChildNodes();
                int limit = transfNodeList.getLength();
                for (j = 0; j < limit; ++j) {
                    String type2;
                    Node aux = transfNodeList.item(j);
                    Element elemAux = (Element)aux;
                    if (!elemAux.hasAttribute("type") || !transformations.contains(type2 = elemAux.getAttribute("type"))) continue;
                    child.removeChild(aux);
                    modified = true;
                }
                if (transfNodeList.getLength() != 0) continue;
                rootNode.getParentNode().removeChild(rootNode);
                continue;
            }
            if (!"transformation".equals(nodeName)) continue;
            if (child.hasAttribute("type") && transformations.contains(type = child.getAttribute("type"))) {
                rootNode.removeChild(child);
                modified = true;
            }
            boolean thereAreMoreTransformations = false;
            int childSize2 = children.getLength();
            for (j = 0; j < childSize2 && !thereAreMoreTransformations; ++j) {
                Node childNode2 = children.item(j);
                if (!(childNode2 instanceof Element)) continue;
                Element child2 = (Element)childNode2;
                String nodeName2 = child2.getNodeName();
                thereAreMoreTransformations = nodeName2.equals("transformation");
            }
            if (thereAreMoreTransformations || rootNode.getNodeName().equals("walkmod")) continue;
            rootNode.getParentNode().removeChild(rootNode);
        }
        return modified;
    }

    @Override
    public void doAction() throws Exception {
        Document document = this.provider.getDocument();
        Element rootElement = document.getDocumentElement();
        HashSet<String> transformationsToRemove = new HashSet<String>(this.transformations);
        boolean modified = false;
        boolean hasChains = false;
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        Element child = null;
        for (int i = 0; i < childSize; ++i) {
            String name;
            String nodeName;
            Node childNode = children.item(i);
            if (!(childNode instanceof Element) || !"chain".equals(nodeName = (child = (Element)childNode).getNodeName())) continue;
            hasChains = true;
            if (this.chain == null) {
                this.chain = "default";
            }
            if (!child.hasAttribute("name") || !(name = child.getAttribute("name")).equals(this.chain)) continue;
            this.removeTransformation(child, transformationsToRemove);
            modified = true;
        }
        if (!hasChains && (this.chain == null || "default".equals(this.chain))) {
            modified = this.removeTransformation(rootElement, transformationsToRemove);
        }
        if (modified) {
            this.provider.persist();
        }
    }

    @Override
    public AbstractXMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new RemoveTransformationXMLAction(this.chain, this.transformations, (XMLConfigurationProvider)provider, recursive);
    }
}

