/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.xml;

import java.util.HashSet;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.XMLConfigurationProvider;
import org.walkmod.conf.providers.xml.AbstractXMLConfigurationAction;

public class RemoveProvidersXMLAction
extends AbstractXMLConfigurationAction {
    private List<String> providers;

    public RemoveProvidersXMLAction(List<String> providers, XMLConfigurationProvider provider, boolean recursive) {
        super(provider, recursive);
        this.providers = providers;
    }

    @Override
    public void doAction() throws Exception {
        HashSet<String> aux = new HashSet<String>();
        for (String elem : this.providers) {
            String[] partsType = elem.split(":");
            if (partsType.length == 1) {
                elem = "org.walkmod:walkmod-" + elem + "-plugin:" + elem;
            }
            if (partsType.length != 3 && partsType.length != 1) {
                throw new TransformerException("Invalid conf-provider");
            }
            aux.add(elem);
        }
        Document document = this.provider.getDocument();
        Element rootElement = document.getDocumentElement();
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        Element child = null;
        int removed = 0;
        for (int i = 0; i < childSize; ++i) {
            String nodeName;
            Node childNode = children.item(i);
            if (!(childNode instanceof Element) || !"conf-providers".equals(nodeName = (child = (Element)childNode).getNodeName())) continue;
            NodeList moduleNodeList = child.getChildNodes();
            int max = moduleNodeList.getLength();
            for (int j = 0; j < max; ++j) {
                Node providerNode = moduleNodeList.item(j);
                if (!(providerNode instanceof Element)) continue;
                Element elemProvider = (Element)providerNode;
                String type = elemProvider.getAttribute("type");
                String[] partsType = type.split(":");
                if (partsType.length == 1) {
                    type = "org.walkmod:walkmod-" + type + "-plugin:" + type;
                }
                if (partsType.length != 3 && partsType.length != 1) {
                    throw new TransformerException("Invalid conf-provider");
                }
                if (!aux.contains(type)) continue;
                child.removeChild(providerNode);
                ++removed;
            }
            if (removed != max) continue;
            rootElement.removeChild(child);
        }
        if (removed > 0) {
            this.provider.persist();
        }
    }

    @Override
    public AbstractXMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new RemoveProvidersXMLAction(this.providers, (XMLConfigurationProvider)provider, recursive);
    }
}

