/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.xml;

import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.ProviderConfig;
import org.walkmod.conf.providers.XMLConfigurationProvider;
import org.walkmod.conf.providers.xml.AbstractXMLConfigurationAction;

public class AddProviderConfigXMLAction
extends AbstractXMLConfigurationAction {
    private ProviderConfig providerCfg;

    public AddProviderConfigXMLAction(ProviderConfig providerCfg, XMLConfigurationProvider provider, boolean recursive) {
        super(provider, recursive);
        this.providerCfg = providerCfg;
    }

    @Override
    public void doAction() throws Exception {
        Document document = this.provider.getDocument();
        Element rootElement = document.getDocumentElement();
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        boolean exists = false;
        Element child = null;
        Node nextNode = null;
        boolean finish = false;
        for (int i = 0; i < childSize && !exists && !finish; ++i) {
            Node childNode = children.item(i);
            if (!(childNode instanceof Element)) continue;
            String nodeName = childNode.getNodeName();
            if ("conf-providers".equals(nodeName)) {
                Element aux = child = (Element)childNode;
                NodeList cfgchildren = aux.getChildNodes();
                int cfgchildrenSize = cfgchildren.getLength();
                for (int j = 0; j < cfgchildrenSize && !exists; ++j) {
                    Node provNode = cfgchildren.item(j);
                    Element entryElem = (Element)provNode;
                    String otype = entryElem.getAttribute("name");
                    exists = otype.equals(this.providerCfg.getType());
                }
                continue;
            }
            if (!"merge-policies".equals(nodeName) && !"chain".equals(nodeName) && !"transformation".equals(nodeName)) continue;
            nextNode = childNode;
            finish = true;
        }
        if (!exists) {
            Map<String, Object> params;
            List<Element> paramListEment;
            Element element = document.createElement("conf-provider");
            String type = this.providerCfg.getType();
            if (type != null && !"".equals(type)) {
                element.setAttribute("type", type);
            }
            if ((paramListEment = this.createParamsElement(params = this.providerCfg.getParameters())) != null) {
                for (Element param : paramListEment) {
                    element.appendChild(param);
                }
            }
            if (child == null) {
                child = document.createElement("conf-providers");
                if (nextNode == null) {
                    rootElement.appendChild(child);
                } else {
                    rootElement.insertBefore(child, nextNode);
                }
            }
            child.appendChild(element);
            this.provider.persist();
        }
    }

    @Override
    public AbstractXMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new AddProviderConfigXMLAction(this.providerCfg, (XMLConfigurationProvider)provider, recursive);
    }
}

