/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.xml;

import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.XMLConfigurationProvider;
import org.walkmod.conf.providers.xml.AbstractXMLConfigurationAction;

public class AddModulesXMLAction
extends AbstractXMLConfigurationAction {
    private List<String> modules;

    public AddModulesXMLAction(List<String> modules, XMLConfigurationProvider provider) {
        super(provider, false);
        this.modules = modules;
    }

    @Override
    public void doAction() throws Exception {
        Document document = this.provider.getDocument();
        Element rootElement = document.getDocumentElement();
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        boolean exists = false;
        Element child = null;
        HashSet<String> modulesToAdd = new HashSet<String>(this.modules);
        for (int i = 0; i < childSize && !exists; ++i) {
            String nodeName;
            Node childNode = children.item(i);
            if (!(childNode instanceof Element) || !"modules".equals(nodeName = (child = (Element)childNode).getNodeName())) continue;
            NodeList moduleNodeList = child.getChildNodes();
            int max = moduleNodeList.getLength();
            for (int j = 0; j < max; ++j) {
                String value = moduleNodeList.item(j).getTextContent().trim();
                modulesToAdd.remove(value);
            }
        }
        if (!modulesToAdd.isEmpty()) {
            for (String module : modulesToAdd) {
                if (child == null) {
                    child = document.createElement("modules");
                    rootElement.appendChild(child);
                }
                Element element = document.createElement("module");
                element.setTextContent(module);
                child.appendChild(element);
            }
            this.provider.persist();
        }
    }

    @Override
    public AbstractXMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return null;
    }
}

