/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.xml;

import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.XMLConfigurationProvider;
import org.walkmod.conf.providers.xml.AbstractXMLConfigurationAction;

public class AddConfigurationParameterXMLAction
extends AbstractXMLConfigurationAction {
    private String param;
    private String value;
    private String type;
    private String category;
    private String name;
    private String chain;

    public AddConfigurationParameterXMLAction(String param, String value, String type, String category, String name, String chain, XMLConfigurationProvider provider, boolean recursive) {
        super(provider, recursive);
        this.param = param;
        this.value = value;
        this.type = type;
        this.category = category;
        this.name = name;
        this.chain = chain;
    }

    @Override
    public void doAction() throws Exception {
        LinkedList<Element> elementsToModify = new LinkedList<Element>();
        Document document = this.provider.getDocument();
        Element rootElement = document.getDocumentElement();
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        for (int i = 0; i < childSize; ++i) {
            Node childNode = children.item(i);
            if (!(childNode instanceof Element)) continue;
            Element child = (Element)childNode;
            String nodeName = child.getNodeName();
            Element chainToAnalyze = null;
            if ("chain".equals(nodeName)) {
                chainToAnalyze = this.chain != null && !this.chain.equals("") ? child : child;
                if (chainToAnalyze == null) continue;
                NodeList chainChildren = chainToAnalyze.getChildNodes();
                int limit = chainChildren.getLength();
                for (int j = 0; j < limit; ++j) {
                    Node chainChild = chainChildren.item(j);
                    if (!(chainChild instanceof Element)) continue;
                    Element chainElement = (Element)chainChild;
                    String chainElementName = chainElement.getNodeName();
                    if ((this.category == null || !this.category.equals(chainElementName)) && this.category != null) continue;
                    this.analizeBean(chainElement, this.type, this.name, elementsToModify);
                    if (!chainElementName.equals("walker") || this.category != null && !this.category.equals("transformation")) continue;
                    NodeList walkerChildren = chainChild.getChildNodes();
                    int limit2 = walkerChildren.getLength();
                    for (int k = 0; k < limit2; ++k) {
                        Node walkerChild = walkerChildren.item(k);
                        if (!(walkerChild instanceof Element)) continue;
                        if (walkerChild.getNodeName().equals("transformations")) {
                            NodeList transform = walkerChild.getChildNodes();
                            int limit3 = transform.getLength();
                            for (int h = 0; h < limit3; ++h) {
                                Node transformationItem = transform.item(h);
                                if (!(transformationItem instanceof Element)) continue;
                                this.analizeBean((Element)transformationItem, this.type, this.name, elementsToModify);
                            }
                            continue;
                        }
                        this.analizeBean((Element)walkerChild, this.type, this.name, elementsToModify);
                    }
                }
                continue;
            }
            if (!"transformation".equals(nodeName)) continue;
            this.analizeBean(child, this.type, this.name, elementsToModify);
        }
        for (Element current : elementsToModify) {
            NodeList childrenElement = current.getChildNodes();
            int limit = childrenElement.getLength();
            boolean found = false;
            for (int i = 0; i < limit && !found; ++i) {
                Element aux;
                Node item = childrenElement.item(i);
                if (!item.getNodeName().equals("param") || !(aux = (Element)item).getAttribute("name").equals(this.param)) continue;
                aux.setTextContent(this.value);
                found = true;
            }
            if (found) continue;
            Element paramElement = document.createElement("param");
            paramElement.setAttribute("name", this.param);
            paramElement.setTextContent(this.value);
            current.appendChild(paramElement);
        }
        if (!elementsToModify.isEmpty()) {
            this.provider.persist();
        }
    }

    private void analizeBean(Element chainElement, String type, String name, List<Element> elementsToModify) {
        if (chainElement.hasAttribute("type")) {
            String typeAttribute = chainElement.getAttribute("type");
            if (type != null && !"".equals(type) && type.equals(typeAttribute)) {
                if (name != null && !name.equals("")) {
                    if (chainElement.hasAttribute("name") && name.equals(chainElement.getAttribute("name"))) {
                        elementsToModify.add(chainElement);
                    }
                } else {
                    elementsToModify.add(chainElement);
                }
            }
        }
    }

    @Override
    public AbstractXMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new AddConfigurationParameterXMLAction(this.param, this.value, this.type, this.category, this.name, this.chain, (XMLConfigurationProvider)provider, recursive);
    }
}

