/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.walkmod.conf.ConfigurationException;
import org.walkmod.conf.ProjectConfigurationProvider;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.JSONConfigParser;
import org.walkmod.conf.entities.MergePolicyConfig;
import org.walkmod.conf.entities.PluginConfig;
import org.walkmod.conf.entities.ProviderConfig;
import org.walkmod.conf.entities.TransformationConfig;
import org.walkmod.conf.entities.WalkerConfig;
import org.walkmod.conf.entities.impl.ChainConfigImpl;
import org.walkmod.conf.entities.impl.MergePolicyConfigImpl;
import org.walkmod.conf.entities.impl.PluginConfigImpl;
import org.walkmod.conf.entities.impl.ProviderConfigImpl;
import org.walkmod.conf.providers.AbstractChainConfigurationProvider;
import org.walkmod.conf.providers.yml.AddChainYMLAction;
import org.walkmod.conf.providers.yml.AddConfigurationParameterYMLAction;
import org.walkmod.conf.providers.yml.AddModulesYMLAction;
import org.walkmod.conf.providers.yml.AddProviderConfigYMLAction;
import org.walkmod.conf.providers.yml.AddTransformationYMLAction;
import org.walkmod.conf.providers.yml.RemoveChainsYMLAction;
import org.walkmod.conf.providers.yml.RemoveModulesYMLAction;
import org.walkmod.conf.providers.yml.RemovePluginYMLAction;
import org.walkmod.conf.providers.yml.RemoveProvidersYMLAction;
import org.walkmod.conf.providers.yml.RemoveTransformationYMLAction;
import org.walkmod.conf.providers.yml.SetReaderYMLAction;
import org.walkmod.conf.providers.yml.SetWriterYMLAction;

public class YAMLConfigurationProvider
extends AbstractChainConfigurationProvider
implements ProjectConfigurationProvider {
    private Configuration configuration;
    private String fileName;
    private YAMLFactory factory;
    private ObjectMapper mapper;
    private JSONConfigParser converter = new JSONConfigParser();

    public YAMLConfigurationProvider() {
        this("walkmod.yml");
    }

    public YAMLConfigurationProvider(String fileName) {
        this.fileName = fileName;
        this.factory = new YAMLFactory();
        this.mapper = new ObjectMapper((JsonFactory)this.factory);
        this.factory.configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
    }

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void load() throws ConfigurationException {
        try {
            JsonNode next;
            JsonNode current;
            Iterator it;
            JsonNode node = this.mapper.readTree(new File(this.fileName));
            this.inferInitializers(this.configuration);
            if (node.has("plugins")) {
                it = node.get("plugins").iterator();
                LinkedList<PluginConfig> pluginList = new LinkedList<PluginConfig>();
                while (it.hasNext()) {
                    current = (JsonNode)it.next();
                    String pluginId = current.asText();
                    String[] split = pluginId.split(":");
                    if (split.length > 3) continue;
                    String groupId = split[0];
                    String artifactId = split[1];
                    String version = split[2];
                    PluginConfigImpl plugin = new PluginConfigImpl();
                    plugin.setGroupId(groupId);
                    plugin.setArtifactId(artifactId);
                    plugin.setVersion(version);
                    pluginList.add(plugin);
                }
                this.configuration.setPlugins(pluginList);
            }
            if (node.has("modules")) {
                it = node.get("modules").iterator();
                LinkedList<String> modules = new LinkedList<String>();
                this.configuration.setModules(modules);
                while (it.hasNext()) {
                    current = (JsonNode)it.next();
                    modules.add(current.asText());
                }
                this.configuration.setModules(modules);
            }
            if (node.has("merge-policies")) {
                it = node.get("merge-policies").iterator();
                LinkedList<MergePolicyConfig> mergePolicies = new LinkedList<MergePolicyConfig>();
                while (it.hasNext()) {
                    next = (JsonNode)it.next();
                    if (!next.has("policy")) continue;
                    MergePolicyConfigImpl mergeCfg = new MergePolicyConfigImpl();
                    mergeCfg.setName(next.get("name").asText());
                    mergeCfg.setDefaultObjectPolicy(next.get("default-object-policy").asText());
                    mergeCfg.setDefaultTypePolicy(next.get("default-type-policy").asText());
                    if (next.has("policy")) {
                        Iterator it2 = next.get("policy").iterator();
                        HashMap<String, String> policies = new HashMap<String, String>();
                        while (it2.hasNext()) {
                            JsonNode nextPolicy = (JsonNode)it2.next();
                            String objectType = nextPolicy.get("object-type").asText();
                            String policyType = nextPolicy.get("policy-type").asText();
                            policies.put(objectType, policyType);
                        }
                        mergeCfg.setPolicyEntries(policies);
                    }
                    mergePolicies.add(mergeCfg);
                }
                this.configuration.setMergePolicies(mergePolicies);
            }
            if (node.has("conf-providers")) {
                it = node.get("conf-providers").iterator();
                LinkedList<ProviderConfig> provConfigs = new LinkedList<ProviderConfig>();
                while (it.hasNext()) {
                    next = (JsonNode)it.next();
                    ProviderConfigImpl provCfg = new ProviderConfigImpl();
                    provCfg.setType(next.get("type").asText());
                    provCfg.setParameters(this.converter.getParams(next));
                    provConfigs.add(provCfg);
                }
                this.configuration.setProviderConfigurations(provConfigs);
            }
            if (node.has("chains")) {
                it = node.get("chains").iterator();
                LinkedList<ChainConfig> chains = new LinkedList<ChainConfig>();
                int i = 0;
                while (it.hasNext()) {
                    ChainConfigImpl chainCfg = new ChainConfigImpl();
                    JsonNode current2 = (JsonNode)it.next();
                    if (current2.has("name")) {
                        chainCfg.setName(current2.get("name").asText());
                    } else {
                        chainCfg.setName("chain_" + i);
                    }
                    if (current2.has("reader")) {
                        JsonNode reader = current2.get("reader");
                        chainCfg.setReaderConfig(this.converter.getReader(reader));
                    } else {
                        this.addDefaultReaderConfig(chainCfg);
                    }
                    if (current2.has("writer")) {
                        JsonNode writer = current2.get("writer");
                        chainCfg.setWriterConfig(this.converter.getWriter(writer));
                    } else {
                        this.addDefaultWriterConfig(chainCfg);
                    }
                    if (current2.has("walker")) {
                        chainCfg.setWalkerConfig(this.converter.getWalker(current2));
                    } else {
                        this.addDefaultWalker(chainCfg);
                        if (current2.has("transformations")) {
                            WalkerConfig walkerCfg = chainCfg.getWalkerConfig();
                            walkerCfg.setTransformations(this.converter.getTransformationCfgs(current2));
                        }
                    }
                    chains.add(chainCfg);
                }
                this.configuration.setChainConfigs(chains);
            } else if (node.has("transformations")) {
                LinkedList<ChainConfig> chains = new LinkedList<ChainConfig>();
                ChainConfigImpl chainCfg = new ChainConfigImpl();
                chainCfg.setName("");
                this.addDefaultReaderConfig(chainCfg);
                this.addDefaultWalker(chainCfg);
                WalkerConfig walkerCfg = chainCfg.getWalkerConfig();
                walkerCfg.setTransformations(this.converter.getTransformationCfgs(node));
                this.addDefaultWriterConfig(chainCfg);
                chains.add(chainCfg);
                this.configuration.setChainConfigs(chains);
            }
        }
        catch (JsonProcessingException e) {
            throw new ConfigurationException("Error parsing the " + this.fileName + " configuration", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading the " + this.fileName + " configuration", e);
        }
        this.inferPlugins(this.configuration);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addPluginConfig(PluginConfig pluginConfig, boolean recursive) throws TransformerException {
        File cfg = new File(this.fileName);
        ArrayNode pluginList = null;
        JsonNode node = null;
        try {
            node = this.mapper.readTree(cfg);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (node == null) {
            node = new ObjectNode(this.mapper.getNodeFactory());
        }
        if (recursive && node.has("modules")) {
            JsonNode aux = node.get("modules");
            if (!aux.isArray()) return;
            ArrayNode modules = (ArrayNode)aux;
            int max = modules.size();
            for (int i = 0; i < max; ++i) {
                JsonNode module = modules.get(i);
                if (!module.isTextual()) continue;
                String moduleDir = module.asText();
                try {
                    File auxFile = new File(this.fileName).getCanonicalFile().getParentFile();
                    YAMLConfigurationProvider child = new YAMLConfigurationProvider(auxFile.getAbsolutePath() + File.separator + moduleDir + File.separator + "walkmod.yml");
                    child.createConfig();
                    child.addPluginConfig(pluginConfig, recursive);
                    continue;
                }
                catch (IOException e) {
                    throw new TransformerException(e);
                }
            }
            return;
        } else {
            if (!node.has("plugins")) {
                pluginList = new ArrayNode(this.mapper.getNodeFactory());
                if (!node.isObject()) throw new TransformerException("The root element is not a JSON node");
                ObjectNode aux = (ObjectNode)node;
                aux.set("plugins", (JsonNode)pluginList);
            } else {
                JsonNode aux = node.get("plugins");
                if (!aux.isArray()) throw new TransformerException("The plugins element is not a valid array");
                pluginList = (ArrayNode)node.get("plugins");
            }
            pluginList.add((JsonNode)new TextNode(pluginConfig.getGroupId() + ":" + pluginConfig.getArtifactId() + ":" + pluginConfig.getVersion()));
            this.write(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(JsonNode node) throws TransformerException {
        if (node != null) {
            File cfg = new File(this.fileName);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(cfg);
                JsonGenerator generator = this.mapper.getFactory().createGenerator((OutputStream)fos);
                generator.useDefaultPrettyPrinter();
                this.mapper.writeTree(generator, node);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        throw new TransformerException("Error writting the configuration", e);
                    }
                }
            }
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    @Override
    public void addChainConfig(ChainConfig chainCfg, boolean recursive) throws Exception {
        AddChainYMLAction action = new AddChainYMLAction(chainCfg, this, recursive);
        action.execute();
    }

    @Override
    public void addTransformationConfig(String chain, String path, TransformationConfig transformationCfg, boolean recursive) throws Exception {
        if (transformationCfg != null) {
            AddTransformationYMLAction action = new AddTransformationYMLAction(chain, path, transformationCfg, this, recursive);
            action.execute();
        }
    }

    @Override
    public void createConfig() throws IOException {
        File cfg = new File(this.fileName);
        if (!cfg.exists() && !cfg.createNewFile()) {
            throw new IOException("The system can't create the [" + this.fileName + "] file");
        }
    }

    public JsonNode getRootNode() {
        File cfg = new File(this.fileName);
        JsonNode node = null;
        try {
            node = this.mapper.readTree(cfg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (node == null) {
            node = new ObjectNode(this.mapper.getNodeFactory());
        }
        return node;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void addProviderConfig(ProviderConfig providerCfg, boolean recursive) throws Exception {
        AddProviderConfigYMLAction action = new AddProviderConfigYMLAction(providerCfg, this, recursive);
        action.execute();
    }

    @Override
    public void addModules(List<String> modules) throws Exception {
        AddModulesYMLAction action = new AddModulesYMLAction(modules, this);
        action.execute();
    }

    @Override
    public void removeTransformations(String chain, List<String> transformations, boolean recursive) throws Exception {
        if (transformations != null && !transformations.isEmpty()) {
            RemoveTransformationYMLAction action = new RemoveTransformationYMLAction(chain, transformations, this, recursive);
            action.execute();
        }
    }

    @Override
    public void setWriter(String chain, String type, String path, boolean recursive) throws Exception {
        if (type != null && !"".equals(type.trim()) || path != null && !"".equals(path.trim())) {
            SetWriterYMLAction action = new SetWriterYMLAction(chain, type, path, this, recursive);
            action.execute();
        }
    }

    @Override
    public void setReader(String chain, String type, String path, boolean recursive) throws Exception {
        if (type != null && !"".equals(type.trim()) || path != null && !"".equals(path.trim())) {
            SetReaderYMLAction action = new SetReaderYMLAction(chain, type, path, this, recursive);
            action.execute();
        }
    }

    @Override
    public void removePluginConfig(PluginConfig pluginConfig, boolean recursive) throws Exception {
        RemovePluginYMLAction action = new RemovePluginYMLAction(pluginConfig, this, recursive);
        action.execute();
    }

    @Override
    public void removeModules(List<String> modules) throws Exception {
        if (modules != null) {
            RemoveModulesYMLAction action = new RemoveModulesYMLAction(modules, this);
            action.execute();
        }
    }

    @Override
    public void removeProviders(List<String> providers, boolean recursive) throws Exception {
        if (providers != null) {
            RemoveProvidersYMLAction action = new RemoveProvidersYMLAction(providers, this, recursive);
            action.execute();
        }
    }

    @Override
    public void removeChains(List<String> chains, boolean recursive) throws Exception {
        if (chains != null) {
            RemoveChainsYMLAction action = new RemoveChainsYMLAction(chains, this, recursive);
            action.execute();
        }
    }

    @Override
    public void addConfigurationParameter(String param, String value, String type, String category, String name, String chain, boolean recursive) throws Exception {
        if (param != null && value != null) {
            AddConfigurationParameterYMLAction action = new AddConfigurationParameterYMLAction(param, value, type, category, name, chain, this, recursive);
            action.execute();
        }
    }

    @Override
    public String getFileExtension() {
        return "yml";
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public File getConfigurationFile() {
        return new File(this.fileName);
    }

    @Override
    public ProjectConfigurationProvider clone(File cfgFile) {
        return new YAMLConfigurationProvider(cfgFile.getAbsolutePath());
    }
}

