/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.walkmod.conf.ConfigurationException;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.PluginConfig;

public class IvyConfigurationProvider
implements ConfigurationProvider {
    private Configuration configuration;
    private boolean isOffLine;
    private Ivy ivy = null;
    private File ivyfile;
    private ResolveOptions resolveOptions;
    private DefaultModuleDescriptor md;
    private static final String IVY_SETTINGS_FILE = "ivysettings.xml";
    private static final Log LOG = LogFactory.getLog(IvyConfigurationProvider.class);

    public IvyConfigurationProvider() {
        this(false);
    }

    public IvyConfigurationProvider(boolean isOffLine) {
        this.setOffLine(isOffLine);
    }

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
    }

    public void initIvy() throws ParseException, IOException, ConfigurationException {
        IvySettings ivySettings = new IvySettings();
        File settingsFile = new File(IVY_SETTINGS_FILE);
        if (settingsFile.exists()) {
            ivySettings.load(settingsFile);
        } else {
            URL settingsURL = ClassLoader.getSystemResource(IVY_SETTINGS_FILE);
            if (settingsURL == null && (settingsURL = this.getClass().getClassLoader().getResource(IVY_SETTINGS_FILE)) == null) {
                throw new ConfigurationException("Ivy settings file (ivysettings.xml) could not be found in classpath");
            }
            ivySettings.load(settingsURL);
        }
        this.ivy = Ivy.newInstance((IvySettings)ivySettings);
        this.ivyfile = File.createTempFile("ivy", ".xml");
        this.ivyfile.deleteOnExit();
        String[] confs = new String[]{"default"};
        this.resolveOptions = new ResolveOptions().setConfs(confs);
        if (this.isOffLine) {
            this.resolveOptions = this.resolveOptions.setUseCacheOnly(true);
        } else {
            boolean offline;
            String offlineOpt;
            Object value;
            Map<String, Object> params = this.configuration.getParameters();
            if (params != null && (value = params.get("offline")) != null && (offlineOpt = value.toString()) != null && (offline = Boolean.parseBoolean(offlineOpt))) {
                this.resolveOptions = this.resolveOptions.setUseCacheOnly(true);
            }
        }
    }

    @Override
    public void load() throws ConfigurationException {
        Collection<PluginConfig> plugins = this.configuration.getPlugins();
        PluginConfig plugin = null;
        Collection<Object> jarsToLoad = new LinkedList();
        ConfigurationException ce = null;
        try {
            if (plugins != null) {
                Iterator<PluginConfig> it = plugins.iterator();
                this.initIvy();
                while (it.hasNext()) {
                    plugin = it.next();
                    this.addArtifact(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion());
                }
                jarsToLoad = this.resolveArtifacts();
                URL[] urls = new URL[jarsToLoad.size()];
                int i = 0;
                for (File file : jarsToLoad) {
                    urls[i] = file.toURI().toURL();
                    ++i;
                }
                URLClassLoader childClassLoader = new URLClassLoader(urls, this.configuration.getClassLoader());
                this.configuration.setClassLoader(childClassLoader);
            }
        }
        catch (Exception e) {
            ce = !(e instanceof ConfigurationException) ? (plugin == null ? new ConfigurationException("Unable to initialize ivy configuration:" + e.getMessage()) : new ConfigurationException("Unable to resolve the plugin: " + plugin.getGroupId() + " : " + plugin.getArtifactId() + " : " + plugin.getVersion() + ". Reason : " + e.getMessage())) : (ConfigurationException)e;
            throw ce;
        }
    }

    public void addArtifact(String groupId, String artifactId, String version) throws Exception {
        String[] dep = null;
        dep = new String[]{groupId, artifactId, version};
        if (this.md == null) {
            this.md = DefaultModuleDescriptor.newDefaultInstance((ModuleRevisionId)ModuleRevisionId.newInstance((String)dep[0], (String)(dep[1] + "-caller"), (String)"working"));
        }
        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor((ModuleDescriptor)this.md, ModuleRevisionId.newInstance((String)dep[0], (String)dep[1], (String)dep[2]), false, false, true);
        this.md.addDependency((DependencyDescriptor)dd);
        DefaultExcludeRule er = new DefaultExcludeRule(new ArtifactId(new ModuleId("org.walkmod", "walkmod-core"), "*", "*", "*"), (PatternMatcher)ExactPatternMatcher.INSTANCE, null);
        dd.addExcludeRule(null, (ExcludeRule)er);
    }

    public Collection<File> resolveArtifacts() throws Exception {
        if (this.ivy != null) {
            XmlModuleDescriptorWriter.write((ModuleDescriptor)this.md, (File)this.ivyfile);
            ResolveReport report = this.ivy.resolve(this.ivyfile.toURL(), this.resolveOptions);
            if (!report.hasError()) {
                ArtifactDownloadReport[] artifacts = report.getAllArtifactsReports();
                LinkedList<File> result = new LinkedList<File>();
                for (ArtifactDownloadReport item : artifacts) {
                    result.add(item.getLocalFile());
                }
                return result;
            }
            List problems = report.getAllProblemMessages();
            if (problems == null || problems.isEmpty()) {
                throw new ConfigurationException("Ivy can not resolve the artifacts. Undefined cause");
            }
            String msg = "";
            Iterator it = problems.iterator();
            while (it.hasNext()) {
                String error = it.next().toString();
                LOG.warn((Object)error);
                if ("".equals(msg)) {
                    msg = error;
                    continue;
                }
                msg = msg + ";" + error;
            }
            throw new ConfigurationException("Ivy can not resolve the artifacts. Cause: " + msg);
        }
        return null;
    }

    public void setOffLine(boolean isOffLine) {
        this.isOffLine = isOffLine;
    }

    public boolean isOffLine() {
        return this.isOffLine;
    }
}

