/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.InitializerConfig;
import org.walkmod.conf.entities.PluginConfig;
import org.walkmod.conf.entities.ProviderConfig;
import org.walkmod.conf.entities.ReaderConfig;
import org.walkmod.conf.entities.TransformationConfig;
import org.walkmod.conf.entities.impl.InitializerConfigImpl;
import org.walkmod.conf.entities.impl.ParserConfigImpl;
import org.walkmod.conf.entities.impl.PluginConfigImpl;
import org.walkmod.conf.entities.impl.WalkerConfigImpl;
import org.walkmod.conf.entities.impl.WriterConfigImpl;

public class AbstractChainConfigurationProvider {
    public void addDefaultReaderConfig(ChainConfig ac) {
        ReaderConfig readerConfig = new ReaderConfig();
        readerConfig.setPath(null);
        readerConfig.setType(null);
        ac.setReaderConfig(readerConfig);
    }

    public void addDefaultWalker(ChainConfig ac) {
        WalkerConfigImpl wc = new WalkerConfigImpl();
        wc.setType(null);
        wc.setParserConfig(new ParserConfigImpl());
        ac.setWalkerConfig(wc);
    }

    public void addDefaultWriterConfig(ChainConfig ac) {
        WriterConfigImpl wc = new WriterConfigImpl();
        wc.setPath(ac.getReaderConfig().getPath());
        wc.setType(null);
        ac.setWriterConfig(wc);
    }

    public void inferInitializers(Configuration config) {
        InitializerConfigImpl init = null;
        File pom = new File("pom.xml");
        if (pom.exists()) {
            init = new InitializerConfigImpl();
            init.setType("maven-initializer");
        } else {
            File gradle = new File("settings.gradle");
            if (gradle.exists()) {
                init = new InitializerConfigImpl();
                init.setType("gradle-initializer");
            }
        }
        if (init != null) {
            List<InitializerConfig> list = config.getInitializers();
            if (list == null) {
                list = new LinkedList<InitializerConfig>();
            }
            list.add(init);
            config.setInitializers(list);
        }
    }

    public void inferPlugins(Configuration config) {
        List<InitializerConfig> list;
        Collection<ProviderConfig> providers;
        Collection<PluginConfig> pluginCfg = config.getPlugins();
        HashSet<String> plugins = new HashSet<String>();
        HashSet<String> previousPlugins = new HashSet<String>();
        if (pluginCfg == null || pluginCfg.isEmpty()) {
            pluginCfg = new LinkedList<PluginConfig>();
        } else {
            for (PluginConfig pc : pluginCfg) {
                previousPlugins.add(pc.getGroupId() + ":" + pc.getArtifactId());
            }
        }
        Collection<ChainConfig> chains = config.getChainConfigs();
        if (chains != null) {
            for (ChainConfig chainConfig : chains) {
                this.composeName(chainConfig.getReaderConfig().getType(), plugins);
                this.composeName(chainConfig.getWalkerConfig().getParserConfig().getType(), plugins);
                List<TransformationConfig> trans = chainConfig.getWalkerConfig().getTransformations();
                if (trans != null) {
                    for (TransformationConfig transformation : trans) {
                        String type = transformation.getType();
                        this.composeName(type, plugins);
                    }
                }
                this.composeName(chainConfig.getWriterConfig().getType(), plugins);
            }
        }
        if ((providers = config.getProviderConfigurations()) != null) {
            for (ProviderConfig provider : providers) {
                String type = provider.getType();
                this.composeName(type, plugins);
            }
        }
        if ((list = config.getInitializers()) != null) {
            for (InitializerConfig initializer : list) {
                plugins.add(initializer.getPluginGroupId() + ":walkmod-" + initializer.getPluginArtifactId() + "-plugin");
            }
        }
        for (String id : plugins) {
            if (previousPlugins.contains(id)) continue;
            String[] parts = id.split(":");
            PluginConfigImpl cfg = new PluginConfigImpl();
            cfg.setGroupId(parts[0].trim());
            cfg.setArtifactId(parts[1].trim());
            cfg.setVersion("latest.integration");
            pluginCfg.add(cfg);
        }
        config.setPlugins(pluginCfg);
    }

    private void composeName(String type, HashSet<String> plugins) {
        if (type != null && !type.startsWith("walkmod:commons")) {
            String aux;
            String[] parts = type.split(":");
            if (parts.length == 3) {
                plugins.add(parts[0] + ":" + parts[1]);
            } else if (parts.length <= 2 && (aux = parts[0].trim()).length() > 0) {
                plugins.add("org.walkmod:walkmod-" + aux + "-plugin");
            }
        }
    }
}

