/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.entities.impl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.walkmod.ChainReader;
import org.walkmod.ChainWalker;
import org.walkmod.ChainWriter;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.Initializer;
import org.walkmod.conf.entities.BeanDefinition;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.InitializerConfig;
import org.walkmod.conf.entities.MergePolicyConfig;
import org.walkmod.conf.entities.PluginConfig;
import org.walkmod.conf.entities.PropertyDefinition;
import org.walkmod.conf.entities.ProviderConfig;
import org.walkmod.conf.entities.impl.BeanDefinitionImpl;
import org.walkmod.conf.entities.impl.PropertyDefinitionImpl;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.merger.MergeEngine;
import org.walkmod.merger.MergePolicy;
import org.walkmod.walkers.VisitorMessage;

public class ConfigurationImpl
implements Configuration {
    private Map<String, Object> parameters = new LinkedHashMap<String, Object>();
    private Map<String, ChainConfig> chainConfigs = new LinkedHashMap<String, ChainConfig>();
    private BeanFactory beanFactory = null;
    private Collection<PluginConfig> plugins;
    private ClassLoader classLoader = null;
    private Collection<MergePolicyConfig> mergePolicies;
    private Map<String, MergeEngine> mergeEngines = new LinkedHashMap<String, MergeEngine>();
    private String defaultLanguage = null;
    private Collection<ProviderConfig> providers;
    private List<InitializerConfig> initializers;
    private List<String> modules;
    private BeanDefinitionRegistry beanDefinitionRegistry;

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Collection<ChainConfig> getChainConfigs() {
        return this.chainConfigs.values();
    }

    @Override
    public void setChainConfigs(Collection<ChainConfig> chainConfigs) {
        this.chainConfigs.clear();
        for (ChainConfig current : chainConfigs) {
            current.setConfiguration(this);
            this.chainConfigs.put(current.getName(), current);
        }
    }

    @Override
    public boolean addChainConfig(ChainConfig architecture) {
        boolean result = this.chainConfigs.containsKey(architecture.getName());
        if (!result) {
            architecture.setConfiguration(this);
            this.chainConfigs.put(architecture.getName(), architecture);
        }
        return result;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Override
    public Object getBean(String name, Map<?, ?> parameters) {
        Object result = null;
        if (name == null || "".equals(name)) {
            return result;
        }
        if (this.beanFactory != null && this.beanFactory.containsBean(name)) {
            result = this.beanFactory.getBean(name);
        }
        if (!name.contains(":")) {
            result = this.beanFactory.getBean("org.walkmod:walkmod-" + name + "-plugin:" + name);
        } else {
            String[] parts = name.split(":");
            if (parts.length == 2) {
                String pluginId = parts[0].trim();
                String beanId = parts[1].trim();
                if (pluginId.length() > 0 && beanId.length() > 0) {
                    result = this.beanFactory.getBean("org.walkmod:walkmod-" + pluginId + "-plugin:" + beanId);
                }
            }
        }
        if (result == null) {
            try {
                Class<?> clazz = this.getClassLoader().loadClass(name);
                result = clazz.newInstance();
            }
            catch (Exception e) {
                throw new WalkModException("Sorry, it is impossible to load the bean " + name + ". Please, assure that it is a valid class name and the library which contains it is in the classpath", e);
            }
        }
        if (result != null) {
            MutablePropertyValues pvs;
            BeanWrapperImpl bw = new BeanWrapperImpl(result);
            if (this.parameters != null) {
                pvs = new MutablePropertyValues(this.parameters);
                bw.setPropertyValues((PropertyValues)pvs, true, true);
            }
            if (parameters != null) {
                pvs = new MutablePropertyValues(parameters);
                bw.setPropertyValues((PropertyValues)pvs, true, true);
            }
        }
        return result;
    }

    @Override
    public void populate(Object element, Map<?, ?> parameters) {
        if (element != null) {
            BeanWrapperImpl bw = new BeanWrapperImpl(element);
            if (this.parameters != null) {
                bw.setPropertyValues(this.parameters);
            }
            bw.setPropertyValues(parameters);
        }
    }

    @Override
    public Collection<VisitorMessage> getVisitorMessages() {
        LinkedList<VisitorMessage> result = new LinkedList<VisitorMessage>();
        if (this.getChainConfigs() != null) {
            for (ChainConfig aqConfig : this.getChainConfigs()) {
                result.addAll(aqConfig.getWalkerConfig().getWalker().getVisitorMessages());
            }
        }
        return result;
    }

    @Override
    public Collection<PluginConfig> getPlugins() {
        return this.plugins;
    }

    @Override
    public void setPlugins(Collection<PluginConfig> plugins) {
        this.plugins = plugins;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Collection<MergePolicyConfig> getMergePolicies() {
        return this.mergePolicies;
    }

    @Override
    public void setMergePolicies(Collection<MergePolicyConfig> mergePolicies) {
        this.mergePolicies = mergePolicies;
    }

    @Override
    public void setMergeEngines(Map<String, MergeEngine> mergeEngines) {
        this.mergeEngines = mergeEngines;
    }

    @Override
    public MergeEngine getMergeEngine(String name) {
        return this.mergeEngines.get(name);
    }

    @Override
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public void setDefaultLanguage(String defaults) {
        this.defaultLanguage = defaults;
    }

    @Override
    public Collection<ProviderConfig> getProviderConfigurations() {
        return this.providers;
    }

    @Override
    public void setProviderConfigurations(Collection<ProviderConfig> providers) {
        this.providers = providers;
    }

    @Override
    public void setModules(List<String> modules) {
        this.modules = modules;
    }

    @Override
    public List<String> getModules() {
        return this.modules;
    }

    @Override
    public void setInitializers(List<InitializerConfig> initializers) {
        this.initializers = initializers;
    }

    @Override
    public List<InitializerConfig> getInitializers() {
        return this.initializers;
    }

    @Override
    public boolean containsBean(String beanId) {
        if (this.beanFactory != null) {
            if (!beanId.contains(":")) {
                return this.beanFactory.containsBean("org.walkmod:walkmod-" + beanId + "-plugin:" + beanId);
            }
            return this.beanFactory.containsBean(beanId);
        }
        return false;
    }

    @Override
    public List<BeanDefinition> getAvailableBeans(PluginConfig pc) {
        LinkedList<BeanDefinition> result = new LinkedList<BeanDefinition>();
        String[] names = this.beanDefinitionRegistry.getBeanDefinitionNames();
        if (names != null) {
            for (String name : names) {
                if (!name.startsWith(pc.getGroupId() + ":" + pc.getArtifactId())) continue;
                Object o = this.beanFactory.getBean(name);
                String classification = "transformation";
                if (o instanceof ChainReader) {
                    classification = "reader";
                } else if (o instanceof ChainWriter) {
                    classification = "writer";
                } else if (o instanceof ChainWalker) {
                    classification = "walker";
                } else if (o instanceof Initializer) {
                    classification = "initializer";
                } else if (o instanceof ConfigurationProvider) {
                    classification = "conf-provider";
                } else if (o instanceof MergePolicy) {
                    classification = "policy-entry";
                }
                String id = name;
                int index0 = "walkmod-".length();
                int index1 = pc.getArtifactId().indexOf("-plugin");
                if (index1 == -1) continue;
                id = pc.getArtifactId().substring(index0, index1);
                String uniqueFullName = pc.getGroupId() + ":" + pc.getArtifactId() + ":" + id;
                if (!name.equals(uniqueFullName)) {
                    if (this.beanDefinitionRegistry.isAlias(name)) continue;
                    String[] aliases = this.beanDefinitionRegistry.getAliases(name);
                    boolean add = true;
                    if (aliases != null) {
                        for (int i = 0; i < aliases.length && add; ++i) {
                            add = !aliases[i].equals(uniqueFullName);
                        }
                    }
                    if (add) {
                        result.add(new BeanDefinitionImpl(classification, name, this.beanDefinitionRegistry.getBeanDefinition(name).getDescription(), this.getProperties(o)));
                        continue;
                    }
                    result.add(new BeanDefinitionImpl(classification, id, this.beanDefinitionRegistry.getBeanDefinition(name).getDescription(), this.getProperties(o)));
                    continue;
                }
                result.add(new BeanDefinitionImpl(classification, id, this.beanDefinitionRegistry.getBeanDefinition(name).getDescription(), this.getProperties(o)));
            }
        }
        return result;
    }

    private List<PropertyDefinition> getProperties(Object o) {
        LinkedList<PropertyDefinition> result = new LinkedList<PropertyDefinition>();
        PropertyDescriptor[] properties = BeanUtils.getPropertyDescriptors(o.getClass());
        if (properties != null) {
            for (PropertyDescriptor pd : properties) {
                if (pd.getWriteMethod() == null) continue;
                String name = pd.getDisplayName();
                Class<?> clazz = pd.getPropertyType();
                String type = clazz.getSimpleName();
                String value = "";
                if (String.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || clazz.isPrimitive()) {
                    if (pd.getReadMethod() != null) {
                        try {
                            value = pd.getReadMethod().invoke(o, new Object[0]).toString();
                        }
                        catch (Exception e) {}
                    } else {
                        Field[] fields = o.getClass().getDeclaredFields();
                        boolean found = false;
                        for (int i = 0; i < fields.length && !found; ++i) {
                            if (!fields[i].getName().equals(name)) continue;
                            found = true;
                            fields[i].setAccessible(true);
                            try {
                                value = fields[i].get(o).toString();
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                }
                PropertyDefinitionImpl item = new PropertyDefinitionImpl(type, name, value);
                result.add(item);
            }
        }
        return result;
    }

    @Override
    public void setBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) {
        this.beanDefinitionRegistry = beanDefinitionRegistry;
    }
}

