/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.ProjectConfigurationProvider;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.impl.ConfigurationImpl;
import org.walkmod.conf.providers.LanguageConfigurationProvider;
import org.walkmod.conf.providers.PluginsConfigurationProvider;
import org.walkmod.conf.providers.SpringConfigurationProvider;
import org.walkmod.conf.providers.XMLConfigurationProvider;
import org.walkmod.conf.providers.YAMLConfigurationProvider;
import org.walkmod.impl.DefaultConfigurationAdapter;

public class ConfigurationManager {
    private Configuration configuration;
    private List<ConfigurationProvider> configurationProviders = new LinkedList<ConfigurationProvider>();

    public ConfigurationManager(Configuration conf) {
        this.setConfiguration(conf);
    }

    public ConfigurationManager(Configuration conf, ConfigurationProvider ... configurationProviders) {
        this.setConfiguration(conf);
        this.configurationProviders.add(new PluginsConfigurationProvider());
        if (configurationProviders != null) {
            for (ConfigurationProvider cp : configurationProviders) {
                this.configurationProviders.add(cp);
            }
        }
        this.configurationProviders.add(new LanguageConfigurationProvider());
        this.configurationProviders.add(new SpringConfigurationProvider());
    }

    public ConfigurationManager(File walkmodcfg, boolean execute, ConfigurationProvider ... configurationProviders) {
        this.setConfiguration(new ConfigurationImpl());
        if (walkmodcfg.getName().endsWith(".xml")) {
            this.configurationProviders.add(new XMLConfigurationProvider(walkmodcfg.getAbsolutePath(), false));
        } else {
            this.configurationProviders.add(new YAMLConfigurationProvider(walkmodcfg.getAbsolutePath()));
        }
        this.configurationProviders.add(new PluginsConfigurationProvider());
        if (configurationProviders != null) {
            for (ConfigurationProvider cp : configurationProviders) {
                this.configurationProviders.add(cp);
            }
        }
        this.configurationProviders.add(new LanguageConfigurationProvider());
        this.configurationProviders.add(new SpringConfigurationProvider());
        if (execute) {
            this.executeConfigurationProviders();
            DefaultConfigurationAdapter ca = new DefaultConfigurationAdapter();
            ca.setConfiguration(this.configuration);
            ca.prepare();
        }
    }

    public ConfigurationManager(File walkmodcfg, ConfigurationProvider ... configurationProviders) {
        this(walkmodcfg, true, configurationProviders);
    }

    public ConfigurationManager(ConfigurationProvider ... configurationProviders) {
        this(new File("walkmod.xml"), configurationProviders);
    }

    public ProjectConfigurationProvider getProjectConfigurationProvider() {
        for (ConfigurationProvider current : this.configurationProviders) {
            if (!(current instanceof ProjectConfigurationProvider)) continue;
            return (ProjectConfigurationProvider)current;
        }
        return null;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void executeConfigurationProviders() {
        for (ConfigurationProvider current : this.configurationProviders) {
            current.init(this.getConfiguration());
            current.load();
        }
    }

    public List<ConfigurationProvider> getConfigurationProviders() {
        return this.configurationProviders;
    }

    public void setConfigurationProviders(List<ConfigurationProvider> configurationProviders) {
        this.configurationProviders = configurationProviders;
    }

    public void addConfigurationProvider(ConfigurationProvider provider) {
        if (!this.configurationProviders.contains(provider)) {
            this.configurationProviders.add(provider);
        }
    }

    public void clearConfigurationProviders() {
        this.configurationProviders.clear();
    }

    public void destroyConfiguration() {
        this.configuration = null;
    }
}

