/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.walkmod.OptionsBuilder;
import org.walkmod.WalkModFacade;
import org.walkmod.commands.Command;

@Parameters(separators="=", commandDescription="Removes configuration providers from the configuration.")
public class RemoveProviderCommand
implements Command {
    @Parameter(description="List of provider identifiers separated by spaces.", required=true)
    private List<String> providers = null;
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    private JCommander command;
    @Parameter(names={"--recursive", "-R"}, description="Remove the providers to all submodules")
    private boolean recursive = false;
    @Parameter(names={"-e", "--verbose"}, description="Prints the stacktrace of the produced error during the execution")
    private Boolean printErrors = false;

    public RemoveProviderCommand(JCommander command) {
        this.command = command;
    }

    @Override
    public void execute() throws Exception {
        if (this.help) {
            this.command.usage("rm-provider");
        } else {
            WalkModFacade facade = new WalkModFacade(OptionsBuilder.options().printErrors(this.printErrors));
            facade.removeProviders(this.providers, this.recursive);
        }
    }
}

