/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import de.vandermeer.asciitable.v2.V2_AsciiTable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.walkmod.OptionsBuilder;
import org.walkmod.WalkModFacade;
import org.walkmod.commands.AsciiTableAware;
import org.walkmod.commands.Command;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.TransformationConfig;

@Parameters(separators="=", commandDescription="Shows the list of transformations with its params for a chain.")
public class PrintTransformationsCommand
implements Command,
AsciiTableAware {
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    private JCommander command;
    private V2_AsciiTable at = null;
    @Parameter(description="The chain name (identifier)", required=false)
    private List<String> chain;
    private static Logger log = Logger.getLogger(PrintTransformationsCommand.class);

    public PrintTransformationsCommand(JCommander command) {
        this.command = command;
    }

    @Override
    public void execute() throws Exception {
        if (this.help) {
            this.command.usage("transformations");
        } else {
            WalkModFacade facade;
            Configuration cfg;
            if (this.chain == null) {
                this.chain = new LinkedList<String>();
            }
            if (this.chain.isEmpty()) {
                this.chain.add("default");
            }
            if ((cfg = (facade = new WalkModFacade(OptionsBuilder.options())).getConfiguration()) != null) {
                Collection<ChainConfig> chains = cfg.getChainConfigs();
                if (chains != null) {
                    Iterator<ChainConfig> it = chains.iterator();
                    ChainConfig selected = null;
                    while (it.hasNext() && selected == null) {
                        ChainConfig current = it.next();
                        if (!current.getName().equals(this.chain.get(0))) continue;
                        selected = current;
                    }
                    if (selected != null) {
                        this.at = new V2_AsciiTable();
                        this.at.addRule();
                        this.at.addRow(new Object[]{"TRANSFORMATION TYPE", "PARAMETERS", "NAME/ALIAS"});
                        this.at.addStrongRule();
                        List<TransformationConfig> transformations = selected.getWalkerConfig().getTransformations();
                        if (transformations != null) {
                            for (TransformationConfig transf : transformations) {
                                Map<String, Object> parameters = transf.getParameters();
                                if (parameters == null || parameters.isEmpty()) {
                                    this.at.addRow(new Object[]{transf.getType(), "", transf.getName()});
                                } else {
                                    Set<String> keys = parameters.keySet();
                                    int i = 0;
                                    for (String key : keys) {
                                        if (i == 0) {
                                            String name = transf.getName();
                                            if (name == null) {
                                                name = "";
                                            }
                                            this.at.addRow(new Object[]{transf.getType(), "-" + key + ":" + parameters.get(key), ""});
                                        } else {
                                            this.at.addRow(new Object[]{"", "-" + key + ":" + parameters.get(key), ""});
                                        }
                                        ++i;
                                    }
                                }
                                this.at.addRule();
                            }
                        }
                    }
                }
            } else {
                log.error((Object)"Sorry, the current directory does not contain a walkmod configuration file or it is invalid.");
                this.at = new V2_AsciiTable();
                this.at.addRule();
                this.at.addRow(new Object[]{"TRANSFORMATION TYPE", "PARAMETERS", "NAME/ALIAS"});
                this.at.addStrongRule();
                this.at.addRule();
            }
        }
    }

    @Override
    public V2_AsciiTable getTable() {
        return this.at;
    }
}

