/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import de.vandermeer.asciitable.v2.V2_AsciiTable;
import java.util.List;
import org.apache.log4j.Logger;
import org.walkmod.OptionsBuilder;
import org.walkmod.WalkModFacade;
import org.walkmod.commands.AsciiTableAware;
import org.walkmod.commands.Command;
import org.walkmod.conf.entities.Configuration;

@Parameters(separators="=", commandDescription="Shows the list of modules.")
public class PrintModulesCommand
implements Command,
AsciiTableAware {
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    private JCommander command;
    private V2_AsciiTable at = null;
    private static Logger log = Logger.getLogger(PrintModulesCommand.class);

    public PrintModulesCommand(JCommander command) {
        this.command = command;
    }

    @Override
    public void execute() throws Exception {
        if (this.help) {
            this.command.usage("modules");
        } else {
            List<String> modules;
            WalkModFacade facade = new WalkModFacade(OptionsBuilder.options());
            Configuration cfg = facade.getConfiguration();
            if (cfg == null) {
                log.error((Object)"Sorry, the current directory does not contain a walkmod configuration file or it is invalid.");
            }
            this.at = new V2_AsciiTable();
            this.at.addRule();
            this.at.addRow(new Object[]{"MODULE"});
            this.at.addRule();
            if (cfg != null && (modules = cfg.getModules()) != null) {
                for (String module : modules) {
                    this.at.addRow(new Object[]{module});
                }
            }
            this.at.addRule();
        }
    }

    @Override
    public V2_AsciiTable getTable() {
        return this.at;
    }
}

