/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import de.vandermeer.asciitable.v2.V2_AsciiTable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.walkmod.OptionsBuilder;
import org.walkmod.WalkModFacade;
import org.walkmod.commands.AsciiTableAware;
import org.walkmod.commands.Command;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.TransformationConfig;

@Parameters(separators="=", commandDescription="Shows the list of chains with its code transformations.")
public class PrintChainsCommand
implements Command,
AsciiTableAware {
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    private JCommander command;
    private V2_AsciiTable at = null;
    private static Logger log = Logger.getLogger(PrintChainsCommand.class);

    public PrintChainsCommand(JCommander jcommander) {
        this.command = jcommander;
    }

    @Override
    public void execute() throws Exception {
        if (this.help) {
            this.command.usage("chains");
        } else {
            Collection<ChainConfig> chains;
            WalkModFacade facade = new WalkModFacade(OptionsBuilder.options());
            Configuration cfg = facade.getConfiguration();
            this.at = new V2_AsciiTable();
            this.at.addRule();
            this.at.addRow(new Object[]{"CHAIN", "READER PATH", "WRITER PATH", "TRANSFORMATIONS"});
            this.at.addStrongRule();
            if (cfg == null) {
                this.at.addRule();
                log.error((Object)"Sorry, the current directory does not contain a walkmod configuration file or it is invalid.");
            }
            if (cfg != null && (chains = cfg.getChainConfigs()) != null) {
                for (ChainConfig cc : chains) {
                    List<TransformationConfig> transformations = cc.getWalkerConfig().getTransformations();
                    Iterator<TransformationConfig> it = transformations.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        TransformationConfig next = it.next();
                        if (i == 0) {
                            this.at.addRow(new Object[]{cc.getName(), cc.getReaderConfig().getPath(), cc.getWriterConfig().getPath(), "- " + next.getType()});
                        } else {
                            this.at.addRow(new Object[]{"", "", "", "- " + next.getType()});
                        }
                        ++i;
                    }
                    this.at.addRule();
                }
            }
        }
    }

    @Override
    public V2_AsciiTable getTable() {
        return this.at;
    }
}

