/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.walkmod.OptionsBuilder;
import org.walkmod.WalkModFacade;
import org.walkmod.commands.Command;

@Parameters(separators="=", commandDescription="Creates an empty walkmod configuration file in your favorite format (yml or xml).")
public class InitCommand
implements Command {
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    private JCommander command;
    @Parameter(names={"--format", "-f"}, description="configuration format")
    private String format = "yml";

    public InitCommand(JCommander command) {
        this.command = command;
    }

    public InitCommand(String format) {
        this.format = format;
    }

    @Override
    public void execute() throws Exception {
        if (this.help) {
            this.command.usage("init");
        } else {
            WalkModFacade facade = new WalkModFacade(OptionsBuilder.options().configurationFormat(this.format));
            facade.init();
        }
    }
}

