/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameters;
import java.util.Map;
import java.util.Set;
import org.walkmod.commands.Command;

@Parameters(hidden=true, separators="=", commandDescription="Shows the command line tool commands")
public class HelpCommand
implements Command {
    private JCommander command;

    public HelpCommand(JCommander command) {
        this.command = command;
    }

    @Override
    public void execute() throws Exception {
        Map commandList = this.command.getCommands();
        Set goals = commandList.keySet();
        System.out.println("Usage: walkmod COMMAND [arg...]");
        System.out.println("       walkmod [ -h | --help | -v | --version ]");
        System.out.println();
        System.out.println("Options:");
        for (String goal : goals) {
            if (!goal.startsWith("--")) continue;
            System.out.printf("  %-13.40s  %-40.100s%n", goal, this.command.getCommandDescription(goal));
        }
        System.out.println();
        System.out.println("Commands:");
        for (String goal : goals) {
            if (goal.startsWith("--")) continue;
            System.out.printf("  %-13.40s  %-40.100s%n", goal, this.command.getCommandDescription(goal));
        }
        System.out.println();
        System.out.println("Run 'walkmod COMMAND --help' for more information on a command.");
    }
}

