/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.OptionsBuilder;
import org.walkmod.WalkModFacade;
import org.walkmod.commands.Command;
import org.walkmod.commands.JSONConverter;
import org.walkmod.conf.entities.JSONConfigParser;
import org.walkmod.conf.entities.TransformationConfig;
import org.walkmod.conf.entities.impl.TransformationConfigImpl;

@Parameters(separators="=", commandDescription="Adds a code transformation/convention into a chain.")
public class AddTransformationCommand
implements Command {
    @Parameter(names={"--params"}, description="Transformation parameters as JSON object", converter=JSONConverter.class)
    private JsonNode params = null;
    @Parameter(names={"--merge-policy"}, description="Merge policy to apply after executing the transformation")
    private String mergePolicy = null;
    @Parameter(names={"--chain"}, description="The chain name")
    private String chain = "default";
    @Parameter(names={"--isMergeabe"}, description="Sets if the changes made by the transformation requires to be merged")
    private boolean isMergeable = false;
    @Parameter(names={"--path", "-d"}, description="Source directory when the specified chain does not exists")
    private String path = null;
    @Parameter(names={"--name", "--alias"}, description="Alias to identify the transformation")
    private String name = null;
    @Parameter(arity=1, description="The transformation type identifier", required=true)
    private List<String> type = null;
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    @Parameter(names={"--recursive", "-R"}, description="Adds the transformation to all submodules")
    private boolean recursive = false;
    @Parameter(names={"-e", "--verbose"}, description="Prints the stacktrace of the produced error during the execution")
    private Boolean printErrors = false;
    private JCommander jcommander;

    public AddTransformationCommand(String type, String chain, boolean isMergeable, String mergePolicy, String path, String name, JsonNode params, boolean recursive) {
        this.type = new LinkedList<String>();
        this.type.add(type);
        this.chain = chain;
        this.isMergeable = isMergeable;
        this.mergePolicy = mergePolicy;
        this.params = params;
        this.path = path;
        this.recursive = recursive;
        this.name = name;
    }

    public AddTransformationCommand(JCommander jcommander) {
        this.jcommander = jcommander;
    }

    public TransformationConfig buildTransformationCfg() {
        TransformationConfigImpl tconfig = new TransformationConfigImpl();
        tconfig.setType(this.type.get(0));
        tconfig.isMergeable(this.isMergeable);
        tconfig.setMergePolicy(this.mergePolicy);
        tconfig.setName(this.name);
        if (this.params != null) {
            JSONConfigParser parser = new JSONConfigParser();
            if (!this.params.has("params")) {
                ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                ObjectNode aux = new ObjectNode(mapper.getNodeFactory());
                aux.set("params", this.params);
                tconfig.setParameters(parser.getParams((JsonNode)aux));
            } else {
                tconfig.setParameters(parser.getParams(this.params));
            }
        }
        return tconfig;
    }

    @Override
    public void execute() throws Exception {
        if (this.help) {
            this.jcommander.usage("add");
        } else {
            WalkModFacade facade = new WalkModFacade(OptionsBuilder.options().printErrors(this.printErrors));
            facade.addTransformationConfig(this.chain, this.path, this.recursive, this.buildTransformationCfg());
        }
    }
}

