/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.OptionsBuilder;
import org.walkmod.WalkModFacade;
import org.walkmod.commands.Command;
import org.walkmod.commands.JSONConverter;
import org.walkmod.conf.entities.JSONConfigParser;
import org.walkmod.conf.entities.ProviderConfig;
import org.walkmod.conf.entities.impl.ProviderConfigImpl;

@Parameters(separators="=", commandDescription="Adds a configuration provider (e.g maven or gradle to calculate the project classpath).")
public class AddCfgProviderCommand
implements Command {
    @Parameter(arity=1, description="The configuration provider type identifier", required=true)
    private List<String> type;
    @Parameter(names={"--params"}, description="Transformation parameters as JSON object", converter=JSONConverter.class)
    private JsonNode params;
    private JCommander command;
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    @Parameter(names={"--recursive", "-R"}, description="Adds the provider to all submodules")
    private boolean recursive = false;
    @Parameter(names={"-e", "--verbose"}, description="Prints the stacktrace of the produced error during the execution")
    private Boolean printErrors = false;

    public AddCfgProviderCommand(JCommander command) {
        this.command = command;
    }

    public AddCfgProviderCommand(String type, JsonNode params) {
        this.type = new LinkedList<String>();
        this.type.add(type);
        this.params = params;
    }

    public ProviderConfig build() throws Exception {
        ProviderConfigImpl prov = new ProviderConfigImpl();
        prov.setType(this.type.get(0));
        if (this.params != null) {
            JSONConfigParser parser = new JSONConfigParser();
            prov.setParameters(parser.getParams(this.params));
        }
        return prov;
    }

    @Override
    public void execute() throws Exception {
        if (this.help) {
            this.command.usage("add-provider");
        } else {
            WalkModFacade facade = new WalkModFacade(OptionsBuilder.options().printErrors(this.printErrors));
            facade.addProviderConfig(this.build(), this.recursive);
        }
    }
}

