/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commands;

import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.walkmod.OptionsBuilder;

public class AbstractChainCommand {
    @Parameter(names={"--help"}, help=true, hidden=true)
    private boolean help;
    @Parameter(names={"--offline"}, description="Resolves the walkmod plugins and their dependencies in offline mode")
    private boolean offline = false;
    @Parameter(names={"-e", "--verbose"}, description="Prints the stacktrace of the produced error during the execution")
    private Boolean showException = null;
    @Parameter(names={"-i", "--includes"}, description="Defines a subset of files of the reader path to include")
    private ArrayList<String> includes = null;
    @Parameter(names={"-x", "--excludes"}, description="Defines a subset of files of the reader path to exclude")
    private ArrayList<String> excludes = null;
    @Parameter(description="[chains to execute]")
    private List<String> parameters = new ArrayList<String>();

    public boolean isHelpNeeded() {
        return this.help;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public Boolean getShowException() {
        return this.showException;
    }

    public void setShowException(Boolean showException) {
        this.showException = showException;
    }

    public ArrayList<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(ArrayList<String> includes) {
        this.includes = includes;
    }

    public ArrayList<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(ArrayList<String> excludes) {
        this.excludes = excludes;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public OptionsBuilder buildOptions() {
        String[] includesArray = null;
        String[] excludesArray = null;
        if (this.includes != null && !this.includes.isEmpty()) {
            includesArray = new String[this.includes.size()];
            this.includes.toArray(includesArray);
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            excludesArray = new String[this.excludes.size()];
            this.excludes.toArray(excludesArray);
        }
        this.offline = this.offline;
        this.showException = this.showException != null && this.showException == true;
        return OptionsBuilder.options().verbose(true).offline(this.offline).printErrors(this.showException).includes(includesArray).excludes(excludesArray);
    }
}

