/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.walkmod.ChainAdapter;
import org.walkmod.ChainAdapterFactory;
import org.walkmod.Options;
import org.walkmod.OptionsBuilder;
import org.walkmod.conf.ConfigurationManager;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.Initializer;
import org.walkmod.conf.ProjectConfigurationProvider;
import org.walkmod.conf.entities.BeanDefinition;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.InitializerConfig;
import org.walkmod.conf.entities.PluginConfig;
import org.walkmod.conf.entities.ProviderConfig;
import org.walkmod.conf.entities.TransformationConfig;
import org.walkmod.conf.entities.impl.ConfigurationImpl;
import org.walkmod.conf.providers.IvyConfigurationProvider;
import org.walkmod.exceptions.InvalidConfigurationException;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.impl.DefaultChainAdapterFactory;
import org.walkmod.writers.Summary;
import org.walkmod.writers.VisitorMessagesWriter;

public class WalkModFacade {
    protected static Logger log = Logger.getLogger(WalkModFacade.class);
    private static final String DEFAULT_WALKMOD_FILE_NAME = "walkmod";
    private Options options;
    private String userDir = ".";
    private File cfg;
    private ConfigurationProvider configurationProvider;

    public WalkModFacade(File cfg, boolean offline, boolean verbose, boolean printError) {
        this.cfg = cfg;
        this.options = OptionsBuilder.options().offline(offline).verbose(verbose).printErrors(printError).build();
    }

    public WalkModFacade(File cfg, boolean offline, boolean verbose, boolean printError, String[] includes, String[] excludes) {
        this.cfg = cfg;
        this.options = OptionsBuilder.options().offline(offline).verbose(verbose).printErrors(printError).includes(includes).excludes(excludes).build();
    }

    public WalkModFacade(String cfg, boolean offline, boolean verbose, boolean printError) {
        this(cfg, offline, verbose, printError, null, null);
    }

    @Deprecated
    public WalkModFacade(String cfg, boolean offline, boolean verbose, boolean printError, String[] includes, String[] excludes) {
        this(cfg, offline, verbose, printError, false, includes, excludes);
    }

    @Deprecated
    public WalkModFacade(String cfg, boolean offline, boolean verbose, boolean printError, boolean throwsException, String[] includes, String[] excludes) {
        this.cfg = new File(cfg);
        this.options = OptionsBuilder.options().offline(offline).verbose(verbose).throwException(throwsException).printErrors(printError).includes(includes).excludes(excludes).build();
    }

    @Deprecated
    public WalkModFacade(boolean offline, boolean verbose, boolean printError) {
        this(new File(DEFAULT_WALKMOD_FILE_NAME), offline, verbose, printError);
    }

    @Deprecated
    public WalkModFacade(boolean offline, boolean verbose, boolean printError, String[] includes, String[] excludes) {
        this(new File("walkmod.xml"), offline, verbose, printError, includes, excludes);
    }

    @Deprecated
    public WalkModFacade() {
        this(false, true, false);
    }

    public WalkModFacade(OptionsBuilder optionsBuilder) {
        this(null, optionsBuilder, null);
    }

    public WalkModFacade(File walkmodCfg, OptionsBuilder optionsBuilder, ConfigurationProvider configurationProvider) {
        this.options = optionsBuilder.build();
        this.cfg = walkmodCfg != null ? walkmodCfg.getAbsoluteFile() : new File(this.options.getExecutionDirectory().getAbsolutePath(), "walkmod." + this.options.getConfigurationFormat());
        if (configurationProvider != null) {
            this.configurationProvider = configurationProvider;
        }
    }

    private ConfigurationProvider locateConfigurationProvider() {
        if (this.configurationProvider == null) {
            return new IvyConfigurationProvider(this.options.isOffline());
        }
        return this.configurationProvider;
    }

    public List<File> apply(String ... chains) throws InvalidConfigurationException {
        LinkedList<File> result = new LinkedList<File>();
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        if (this.cfg.exists()) {
            if (this.options.isVerbose()) {
                log.info((Object)(this.cfg.getAbsoluteFile() + " [ok]"));
            }
            ConfigurationProvider cp = this.locateConfigurationProvider();
            ConfigurationManager cfgManager = null;
            Configuration config = null;
            DefaultChainAdapterFactory apf = null;
            try {
                cfgManager = new ConfigurationManager(this.cfg, cp);
                config = cfgManager.getConfiguration();
                apf = new DefaultChainAdapterFactory();
            }
            catch (Exception e) {
                System.setProperty("user.dir", this.userDir);
                if (this.options.isVerbose()) {
                    if (!this.options.isPrintErrors()) {
                        log.error((Object)(this.cfg.getAbsolutePath() + " is invalid. Please, execute walkmod with -e to see the details."));
                    } else {
                        log.error((Object)"Invalid configuration", (Throwable)e);
                    }
                    if (this.options.isThrowException()) {
                        RuntimeException re = new RuntimeException();
                        re.setStackTrace(e.getStackTrace());
                        throw re;
                    }
                    return null;
                }
                throw new InvalidConfigurationException(e);
            }
            List<String> modules = config.getModules();
            if (modules != null && !modules.isEmpty()) {
                for (String module : modules) {
                    File aux = new File(module).getAbsoluteFile();
                    if (aux.isDirectory()) {
                        if (this.options.isVerbose()) {
                            log.info((Object)("** MODULE " + aux.getAbsoluteFile() + " [ok] **"));
                        }
                        WalkModFacade facade = new WalkModFacade(null, OptionsBuilder.options(this.options.asMap()).executionDirectory(aux), null);
                        result.addAll(facade.apply(chains));
                        continue;
                    }
                    log.error((Object)("The module " + aux.getAbsolutePath() + " is not an existing directory"));
                }
            }
            Summary.getInstance().clear();
            Collection<ChainConfig> chainCfgs = config.getChainConfigs();
            if (chainCfgs != null && !chainCfgs.isEmpty()) {
                Summary.getInstance().clear();
                if (chains == null || chains.length == 0) {
                    this.executeAllChains(apf, config);
                } else {
                    for (String chain : chains) {
                        this.executeChainAdapter(apf, config, chain);
                    }
                }
            }
            System.setProperty("user.dir", this.userDir);
        } else {
            System.setProperty("user.dir", this.userDir);
            if (this.options.isVerbose()) {
                log.error((Object)(this.cfg.getAbsolutePath() + " does not exist. The root directory of your project must contain a walkmod.xml"));
            } else {
                throw new WalkModException(this.cfg.getAbsolutePath() + " does not exist. The root directory of your project must contain a walkmod.xml");
            }
        }
        result.addAll(Summary.getInstance().getWrittenFiles());
        return result;
    }

    public List<File> check(String ... chains) throws InvalidConfigurationException {
        LinkedList<File> result = new LinkedList<File>();
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        if (this.cfg.exists()) {
            List<String> modules;
            if (this.options.isVerbose()) {
                log.info((Object)(this.cfg.getAbsoluteFile() + " [ok]"));
            }
            ConfigurationProvider cp = this.locateConfigurationProvider();
            ConfigurationManager cfgManager = null;
            Configuration config = null;
            DefaultChainAdapterFactory apf = null;
            try {
                cfgManager = new ConfigurationManager(this.cfg, cp);
                config = cfgManager.getConfiguration();
                apf = new DefaultChainAdapterFactory();
            }
            catch (Exception e) {
                System.setProperty("user.dir", this.userDir);
                if (this.options.isVerbose()) {
                    if (!this.options.isPrintErrors()) {
                        log.error((Object)(this.cfg.getAbsolutePath() + " is invalid. Please, execute walkmod with -e to see the details."));
                    } else {
                        log.error((Object)"Invalid configuration", (Throwable)e);
                    }
                    if (this.options.isThrowException()) {
                        RuntimeException re = new RuntimeException();
                        re.setStackTrace(e.getStackTrace());
                        throw re;
                    }
                    return null;
                }
                throw new InvalidConfigurationException(e);
            }
            Collection<ChainConfig> tcgfs = config.getChainConfigs();
            if (tcgfs != null) {
                for (ChainConfig chainConfig : tcgfs) {
                    chainConfig.getWriterConfig().setType(VisitorMessagesWriter.class.getName());
                    chainConfig.getWriterConfig().setModelWriter(new VisitorMessagesWriter());
                }
            }
            if ((modules = config.getModules()) != null && !modules.isEmpty()) {
                for (String module : modules) {
                    File aux = new File(module).getAbsoluteFile();
                    if (aux.isDirectory()) {
                        if (this.options.isVerbose()) {
                            log.info((Object)("** MODULE " + aux.getAbsoluteFile() + " [ok] **"));
                        }
                        WalkModFacade facade = new WalkModFacade(null, OptionsBuilder.options(this.options.asMap()).executionDirectory(aux), null);
                        result.addAll(facade.check(chains));
                        continue;
                    }
                    log.error((Object)("The module " + aux.getAbsolutePath() + " is not an existing directory"));
                }
            }
            Summary.getInstance().clear();
            Collection<ChainConfig> collection = config.getChainConfigs();
            if (collection != null && !collection.isEmpty()) {
                Summary.getInstance().clear();
                if (chains == null || chains.length == 0) {
                    this.executeAllChains(apf, config);
                } else {
                    for (String chain : chains) {
                        this.executeChainAdapter(apf, config, chain);
                    }
                }
            }
            System.setProperty("user.dir", this.userDir);
        } else {
            System.setProperty("user.dir", this.userDir);
            if (this.options.isVerbose()) {
                log.error((Object)(this.cfg.getAbsolutePath() + " does not exist. The root directory of your project must contain a walkmod.xml"));
            } else {
                throw new WalkModException(this.cfg.getAbsolutePath() + " does not exist. The root directory of your project must contain a walkmod.xml");
            }
        }
        result.addAll(Summary.getInstance().getWrittenFiles());
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public void init() throws Exception {
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        if (!this.cfg.exists()) {
            manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[]{this.locateConfigurationProvider()});
            cfgProvider = manager.getProjectConfigurationProvider();
            try {
                cfgProvider.createConfig();
                manager.executeConfigurationProviders();
                conf = manager.getConfiguration();
                initializers = conf.getInitializers();
                if (initializers != null) {
                    for (InitializerConfig initCfg : initializers) {
                        beanId = initCfg.getPluginGroupId() + ":walkmod-" + initCfg.getPluginArtifactId() + "-plugin:" + initCfg.getType();
                        if (!conf.containsBean(beanId) || (o = conf.getBean(beanId, initCfg.getParams())) == null || !(o instanceof Initializer)) continue;
                        ((Initializer)o).execute(cfgProvider);
                    }
                }
                if (!this.options.isVerbose()) ** GOTO lbl30
                WalkModFacade.log.info((Object)("CONFIGURATION FILE [" + this.cfg.getAbsolutePath() + "] CREATION COMPLETE"));
            }
            catch (IOException aux) {
                if (this.options.isVerbose()) {
                    WalkModFacade.log.error((Object)("The system can't create the file [ " + this.cfg.getAbsolutePath() + "]"));
                }
                if (!this.options.isThrowException()) ** GOTO lbl30
                System.setProperty("user.dir", this.userDir);
                throw aux;
            }
        } else if (this.options.isVerbose()) {
            WalkModFacade.log.error((Object)("The configuration file [" + this.cfg.getAbsolutePath() + "] already exists"));
        }
lbl30:
        // 6 sources

        System.setProperty("user.dir", this.userDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChainConfig(ChainConfig chainCfg, boolean recursive) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (!this.cfg.exists()) {
            this.init();
        }
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        try {
            ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
            ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
            cfgProvider.addChainConfig(chainCfg, recursive);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            System.setProperty("user.dir", this.userDir);
            this.updateMsg(startTime, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransformationConfig(String chain, String path, boolean recursive, TransformationConfig transformationCfg) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (!this.cfg.exists()) {
            this.init();
        }
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        try {
            ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
            ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
            cfgProvider.addTransformationConfig(chain, path, transformationCfg, recursive);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            System.setProperty("user.dir", this.userDir);
            this.updateMsg(startTime, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProviderConfig(ProviderConfig providerCfg, boolean recursive) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (!this.cfg.exists()) {
            this.init();
        }
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        try {
            ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
            ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
            cfgProvider.addProviderConfig(providerCfg, recursive);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            System.setProperty("user.dir", this.userDir);
            this.updateMsg(startTime, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginConfig(PluginConfig pluginConfig, boolean recursive) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (!this.cfg.exists()) {
            this.init();
        }
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        try {
            ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
            ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
            cfgProvider.addPluginConfig(pluginConfig, recursive);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            System.setProperty("user.dir", this.userDir);
            this.updateMsg(startTime, exception);
        }
    }

    private void updateMsg(long startTime, Exception e) {
        if (this.options.isVerbose()) {
            DecimalFormat myFormatter = new DecimalFormat("###.###");
            SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.US);
            long endTime = System.currentTimeMillis();
            double time = 0.0;
            if (endTime > startTime) {
                time = (double)(endTime - startTime) / 1000.0;
            }
            String timeMsg = myFormatter.format(time);
            System.out.print("----------------------------------------");
            System.out.println("----------------------------------------");
            if (e == null) {
                log.info((Object)"CONFIGURATION UPDATE SUCCESS");
            } else {
                log.info((Object)"CONFIGURATION UPDATE FAILS");
            }
            System.out.println();
            System.out.print("----------------------------------------");
            System.out.println("----------------------------------------");
            log.info((Object)("Total time: " + timeMsg + " seconds"));
            log.info((Object)("Finished at: " + df.format(new Date())));
            log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
            System.out.print("----------------------------------------");
            System.out.println("----------------------------------------");
            if (e != null) {
                if (this.options.isPrintErrors()) {
                    log.error((Object)"Plugin installations fails", (Throwable)e);
                } else {
                    log.info((Object)"Plugin installations fails. Please, execute walkmod with -e to see the details");
                }
                if (this.options.isThrowException()) {
                    RuntimeException re = new RuntimeException();
                    re.setStackTrace(e.getStackTrace());
                    throw re;
                }
            }
        }
    }

    public void install() throws InvalidConfigurationException {
        if (this.cfg.exists()) {
            long startTime;
            if (this.options.isVerbose()) {
                log.info((Object)(this.cfg.getAbsoluteFile() + " [ok]"));
            }
            IvyConfigurationProvider cp = new IvyConfigurationProvider(this.options.isOffline());
            if (this.options.isVerbose()) {
                log.info((Object)"** THE PLUGIN INSTALLATION STARTS **");
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
            }
            long endTime = startTime = System.currentTimeMillis();
            DecimalFormat myFormatter = new DecimalFormat("###.###");
            SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.US);
            boolean error = false;
            try {
                this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
                System.setProperty("user.dir", this.options.getExecutionDirectory().getCanonicalPath());
                ConfigurationManager cfgManager = new ConfigurationManager(this.cfg, cp);
                Configuration cf = cfgManager.getConfiguration();
                List<String> modules = cf.getModules();
                if (modules != null && !modules.isEmpty()) {
                    for (String module : modules) {
                        File aux = new File(module).getAbsoluteFile();
                        if (aux.isDirectory()) {
                            if (this.options.isVerbose()) {
                                log.info((Object)("** MODULE " + aux.getAbsoluteFile() + " [ok] **"));
                            }
                            WalkModFacade facade = new WalkModFacade(null, OptionsBuilder.options(this.options.asMap()).executionDirectory(aux), null);
                            facade.install();
                            continue;
                        }
                        log.error((Object)("The module " + aux.getAbsolutePath() + " is not an existing directory"));
                    }
                }
            }
            catch (Exception e) {
                System.setProperty("user.dir", this.userDir);
                if (this.options.isVerbose()) {
                    error = true;
                    endTime = System.currentTimeMillis();
                    double time = 0.0;
                    if (endTime > startTime) {
                        time = (double)(endTime - startTime) / 1000.0;
                    }
                    String timeMsg = myFormatter.format(time);
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)"PLUGIN INSTALLATION FAILS");
                    System.out.println();
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)("Total time: " + timeMsg + " seconds"));
                    log.info((Object)("Finished at: " + df.format(new Date())));
                    log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    if (this.options.isPrintErrors()) {
                        log.error((Object)"Plugin installations fails", (Throwable)e);
                    } else {
                        log.info((Object)"Plugin installations fails. Please, execute walkmod with -e to see the details");
                    }
                    if (this.options.isThrowException()) {
                        RuntimeException re = new RuntimeException();
                        re.setStackTrace(e.getStackTrace());
                        throw re;
                    }
                }
                throw new InvalidConfigurationException(e);
            }
            if (!error) {
                System.setProperty("user.dir", this.userDir);
                if (this.options.isVerbose()) {
                    endTime = System.currentTimeMillis();
                    double time = 0.0;
                    if (endTime > startTime) {
                        time = (double)(endTime - startTime) / 1000.0;
                    }
                    String timeMsg = myFormatter.format(time);
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    System.out.println();
                    log.info((Object)"PLUGIN INSTALLATION COMPLETE");
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)("Total time: " + timeMsg + " seconds"));
                    log.info((Object)("Finished at: " + df.format(new Date())));
                    log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                }
            }
        } else if (this.options.isVerbose()) {
            log.error((Object)(this.cfg.getAbsolutePath() + " does not exist. The root directory of your project must contain a walkmod.xml"));
        } else {
            throw new WalkModException(this.cfg.getAbsolutePath() + " does not exist. The root directory of your project must contain a walkmod.xml");
        }
    }

    private void executeAllChains(ChainAdapterFactory apf, Configuration conf) {
        Collection<ChainConfig> tcgfs = conf.getChainConfigs();
        if (tcgfs != null) {
            long startTime;
            if (this.options.isVerbose()) {
                log.info((Object)"** STARTING TRANSFORMATIONS CHAINS **");
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
            }
            long endTime = startTime = System.currentTimeMillis();
            DecimalFormat myFormatter = new DecimalFormat("###.###");
            SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.US);
            int num = 0;
            Iterator<ChainConfig> it = tcgfs.iterator();
            int pos = 1;
            while (it.hasNext()) {
                ChainConfig tcfg = it.next();
                if (tcgfs.size() > 1 && this.options.isVerbose()) {
                    String label = "";
                    label = tcfg.getName() != null && !tcfg.getName().startsWith("chain_") ? "[" + tcfg.getName() + "](" + pos + "/" + tcgfs.size() + ") " : "(" + pos + "/" + tcgfs.size() + ")";
                    log.info((Object)("TRANSFORMATION CHAIN " + label));
                    System.out.println();
                }
                try {
                    if (this.options.getIncludes() != null) {
                        String[] includes = this.options.getIncludes().toArray(new String[this.options.getIncludes().size()]);
                        tcfg.getReaderConfig().setIncludes(includes);
                    }
                    if (this.options.getExcludes() != null) {
                        String[] excludes = this.options.getExcludes().toArray(new String[this.options.getExcludes().size()]);
                        tcfg.getReaderConfig().setExcludes(excludes);
                    }
                    ChainAdapter ap = apf.createChainProxy(conf, tcfg.getName());
                    ap.execute();
                    num += ap.getWalkerAdapter().getWalker().getNumModifications();
                    ++pos;
                    if (!this.options.isVerbose()) continue;
                    if (Summary.getInstance().getWrittenFiles().isEmpty()) {
                        log.info((Object)"**No sources changed**");
                    }
                    if (!it.hasNext()) continue;
                    System.out.println();
                }
                catch (Throwable e) {
                    if (this.options.isVerbose()) {
                        endTime = System.currentTimeMillis();
                        double time = 0.0;
                        if (endTime > startTime) {
                            time = (double)(endTime - startTime) / 1000.0;
                        }
                        String timeMsg = myFormatter.format(time);
                        if (num != 0) {
                            System.out.print("----------------------------------------");
                            System.out.println("----------------------------------------");
                        }
                        log.info((Object)"TRANSFORMATION CHAIN FAILS");
                        System.out.println();
                        System.out.print("----------------------------------------");
                        System.out.println("----------------------------------------");
                        log.info((Object)("Total time: " + timeMsg + " seconds"));
                        log.info((Object)("Finished at: " + df.format(new Date())));
                        log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
                        System.out.print("----------------------------------------");
                        System.out.println("----------------------------------------");
                        log.info((Object)"Please, see the walkmod log file for details");
                        if (this.options.isPrintErrors()) {
                            log.error((Object)("TRANSFORMATION CHAIN (" + tcfg.getName() + ") FAILS"), e);
                        } else {
                            log.error((Object)("TRANSFORMATION CHAIN (" + tcfg.getName() + ") FAILS. Execute walkmod with -e to see the error details."));
                        }
                        if (this.options.isThrowException()) {
                            RuntimeException re = new RuntimeException();
                            re.setStackTrace(e.getStackTrace());
                            throw re;
                        }
                    } else {
                        throw new WalkModException(e);
                    }
                    return;
                }
            }
            if (this.options.isVerbose()) {
                endTime = System.currentTimeMillis();
                double time = 0.0;
                if (endTime > startTime) {
                    time = (double)(endTime - startTime) / 1000.0;
                }
                String timeMsg = myFormatter.format(time);
                if (num != 0) {
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                }
                System.out.println();
                log.info((Object)"TRANSFORMATION CHAIN SUCCESS");
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
                log.info((Object)("Total time: " + timeMsg + " seconds"));
                log.info((Object)("Finished at: " + df.format(new Date())));
                log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
                log.info((Object)("Total modified files: " + num));
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
            }
        }
    }

    private void executeChainAdapter(ChainAdapterFactory apf, Configuration conf, String name) {
        ChainAdapter ap;
        Collection<ChainConfig> chains;
        if ((this.options.getIncludes() != null || this.options.getExcludes() != null) && (chains = conf.getChainConfigs()) != null) {
            for (ChainConfig cc : chains) {
                if (this.options.getIncludes() != null) {
                    String[] includes = this.options.getIncludes().toArray(new String[this.options.getIncludes().size()]);
                    cc.getReaderConfig().setIncludes(includes);
                }
                if (this.options.getExcludes() == null) continue;
                String[] excludes = this.options.getExcludes().toArray(new String[this.options.getExcludes().size()]);
                cc.getReaderConfig().setExcludes(excludes);
            }
        }
        if ((ap = apf.createChainProxy(conf, name)) == null) {
            if (this.options.isVerbose()) {
                log.error((Object)("The chain " + name + " is not found"));
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
            }
        } else {
            long startTime;
            long endTime = startTime = System.currentTimeMillis();
            DecimalFormat myFormatter = new DecimalFormat("###.###");
            SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.US);
            if (this.options.isVerbose()) {
                log.info((Object)("** THE TRANSFORMATION CHAIN " + name + " STARTS **"));
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
            }
            int num = 0;
            try {
                ap.execute();
                num = ap.getWalkerAdapter().getWalker().getNumModifications();
                if (this.options.isVerbose()) {
                    endTime = System.currentTimeMillis();
                    double time = 0.0;
                    if (endTime > startTime) {
                        time = (double)(endTime - startTime) / 1000.0;
                    }
                    String timeMsg = myFormatter.format(time);
                    if (num != 0) {
                        System.out.print("----------------------------------------");
                        System.out.println("----------------------------------------");
                    } else if (Summary.getInstance().getWrittenFiles().isEmpty()) {
                        log.info((Object)"**No sources changed**");
                    }
                    System.out.println();
                    log.info((Object)"TRANSFORMATION CHAIN SUCCESS");
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)("Total time: " + timeMsg + " seconds"));
                    log.info((Object)("Finished at: " + df.format(new Date())));
                    log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
                    if (ap.getWalkerAdapter().getWalker().reportChanges()) {
                        log.info((Object)("Total modified files: " + num));
                    }
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                }
            }
            catch (Throwable e) {
                System.setProperty("user.dir", this.userDir);
                if (this.options.isVerbose()) {
                    endTime = System.currentTimeMillis();
                    double time = 0.0;
                    if (endTime > startTime) {
                        time = (double)(endTime - startTime) / 1000.0;
                    }
                    String timeMsg = myFormatter.format(time);
                    if (num != 0) {
                        System.out.print("----------------------------------------");
                        System.out.println("----------------------------------------");
                    }
                    log.info((Object)"TRANSFORMATION CHAIN FAILS");
                    System.out.println();
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)("Total time: " + timeMsg + " seconds"));
                    log.info((Object)("Finished at: " + df.format(new Date())));
                    log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)"Please, see the walkmod log file for details");
                    if (this.options.isPrintErrors()) {
                        log.error((Object)("TRANSFORMATION CHAIN (" + name + ") FAILS"), e);
                    } else {
                        log.error((Object)("TRANSFORMATION CHAIN (" + name + ") FAILS. Execute walkmod with -e to see the error details."));
                    }
                } else {
                    throw new WalkModException(e);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModules(List<String> modules) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (modules != null) {
            if (!this.cfg.exists()) {
                this.init();
            }
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
                cfgProvider.addModules(modules);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                System.setProperty("user.dir", this.userDir);
                this.updateMsg(startTime, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransformations(String chain, List<String> transformations, boolean recursive) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (transformations != null) {
            if (!this.cfg.exists()) {
                this.init();
            }
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
                cfgProvider.removeTransformations(chain, transformations, recursive);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                System.setProperty("user.dir", this.userDir);
                this.updateMsg(startTime, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriter(String chain, String type, String path, boolean recursive) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (type != null && !"".equals(type.trim()) || path != null && !"".equals(path.trim())) {
            if (!this.cfg.exists()) {
                this.init();
            }
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
                cfgProvider.setWriter(chain, type, path, recursive);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                System.setProperty("user.dir", this.userDir);
                this.updateMsg(startTime, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReader(String chain, String type, String path, boolean recursive) throws Exception {
        if (type != null && !"".equals(type.trim()) || path != null && !"".equals(path.trim())) {
            long startTime = System.currentTimeMillis();
            Exception exception = null;
            if (!this.cfg.exists()) {
                this.init();
            }
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
                cfgProvider.setReader(chain, type, path, recursive);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                System.setProperty("user.dir", this.userDir);
                this.updateMsg(startTime, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePluginConfig(PluginConfig pluginConfig, boolean recursive) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (!this.cfg.exists()) {
            this.init();
        }
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        try {
            ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
            ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
            cfgProvider.removePluginConfig(pluginConfig, recursive);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            System.setProperty("user.dir", this.userDir);
            this.updateMsg(startTime, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModules(List<String> modules) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (!this.cfg.exists()) {
            this.init();
        }
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        try {
            ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
            ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
            cfgProvider.removeModules(modules);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            System.setProperty("user.dir", this.userDir);
            this.updateMsg(startTime, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProviders(List<String> providers, boolean recursive) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (!this.cfg.exists()) {
            this.init();
        }
        this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
        System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
        try {
            ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
            ProjectConfigurationProvider cfgProvider = manager.getProjectConfigurationProvider();
            cfgProvider.removeProviders(providers, recursive);
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            System.setProperty("user.dir", this.userDir);
            this.updateMsg(startTime, exception);
        }
    }

    public Configuration getConfiguration() throws Exception {
        Configuration result = null;
        if (this.cfg.exists()) {
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                manager.executeConfigurationProviders();
                result = manager.getConfiguration();
            }
            finally {
                System.setProperty("user.dir", this.userDir);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChains(List<String> chains, boolean recursive) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (this.cfg.exists()) {
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                manager.getProjectConfigurationProvider().removeChains(chains, recursive);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                System.setProperty("user.dir", this.userDir);
                this.updateMsg(startTime, exception);
            }
        }
    }

    public List<BeanDefinition> inspectPlugin(PluginConfig plugin) {
        ConfigurationImpl conf = new ConfigurationImpl();
        LinkedList<PluginConfig> plugins = new LinkedList<PluginConfig>();
        plugins.add(plugin);
        conf.setPlugins(plugins);
        ConfigurationManager manager = new ConfigurationManager(conf, this.locateConfigurationProvider());
        manager.executeConfigurationProviders();
        return conf.getAvailableBeans(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurationParameter(String param, String value, String type, String category, String name, String chain, boolean recursive) throws Exception {
        long startTime = System.currentTimeMillis();
        Exception exception = null;
        if (this.cfg.exists()) {
            this.userDir = new File(System.getProperty("user.dir")).getAbsolutePath();
            System.setProperty("user.dir", this.options.getExecutionDirectory().getAbsolutePath());
            try {
                ConfigurationManager manager = new ConfigurationManager(this.cfg, false, new ConfigurationProvider[0]);
                manager.getProjectConfigurationProvider().addConfigurationParameter(param, value, type, category, name, chain, recursive);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                System.setProperty("user.dir", this.userDir);
                this.updateMsg(startTime, exception);
            }
        }
    }
}

