/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import de.vandermeer.asciitable.v2.RenderedTable;
import de.vandermeer.asciitable.v2.V2_AsciiTable;
import de.vandermeer.asciitable.v2.render.V2_AsciiTableRenderer;
import de.vandermeer.asciitable.v2.render.V2_Width;
import de.vandermeer.asciitable.v2.themes.V2_E_TableThemes;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.walkmod.AsciiTableWidth;
import org.walkmod.commands.AddCfgProviderCommand;
import org.walkmod.commands.AddModuleCommand;
import org.walkmod.commands.AddParamCommand;
import org.walkmod.commands.AddPluginCommand;
import org.walkmod.commands.AddTransformationCommand;
import org.walkmod.commands.ApplyCommand;
import org.walkmod.commands.AsciiTableAware;
import org.walkmod.commands.CheckCommand;
import org.walkmod.commands.Command;
import org.walkmod.commands.HelpCommand;
import org.walkmod.commands.InitCommand;
import org.walkmod.commands.InspectCommand;
import org.walkmod.commands.InstallCommand;
import org.walkmod.commands.PrintChainsCommand;
import org.walkmod.commands.PrintModulesCommand;
import org.walkmod.commands.PrintPluginsCommand;
import org.walkmod.commands.PrintProvidersCommand;
import org.walkmod.commands.PrintTransformationsCommand;
import org.walkmod.commands.RemoveChainCommand;
import org.walkmod.commands.RemoveModuleCommand;
import org.walkmod.commands.RemovePluginCommand;
import org.walkmod.commands.RemoveProviderCommand;
import org.walkmod.commands.RemoveTransformationCommand;
import org.walkmod.commands.SetReaderCommand;
import org.walkmod.commands.SetWriterCommand;
import org.walkmod.commands.VersionCommand;

public class WalkModDispatcher {
    private static Logger log = Logger.getLogger(WalkModDispatcher.class);
    private Map<String, Command> commands = new LinkedHashMap<String, Command>();

    public static void printHeader() {
        log.info((Object)("Java version: " + System.getProperty("java.version")));
        log.info((Object)("Java Home: " + System.getProperty("java.home")));
        log.info((Object)("OS: " + System.getProperty("os.name") + ", Vesion: " + System.getProperty("os.version")));
        System.out.print("----------------------------------------");
        System.out.println("----------------------------------------");
        System.out.print("                    ");
        System.out.print(" _    _       _ _   ___  ___          _ ");
        System.out.println("                    ");
        System.out.print("                    ");
        System.out.print("| |  | |     | | |  |  \\/  |         | |");
        System.out.println("                    ");
        System.out.print("                    ");
        System.out.print("| |  | | __ _| | | _| .  . | ___   __| |");
        System.out.println("                    ");
        System.out.print("                    ");
        System.out.print("| |/\\| |/ _` | | |/ / |\\/| |/ _ \\ / _` |");
        System.out.println("                    ");
        System.out.print("                    ");
        System.out.print("\\  /\\  / (_| | |   <| |  | | (_) | (_| |");
        System.out.println("                    ");
        System.out.print("                    ");
        System.out.print(" \\/  \\/ \\__,_|_|_|\\_\\_|  |_/\\___/ \\__,_|");
        System.out.println("                    ");
        System.out.print("----------------------------------------");
        System.out.println("----------------------------------------");
        System.out.println("An open source tool to apply code conventions");
        System.out.println("version 2.0 - November 2015 -");
        System.out.print("----------------------------------------");
        System.out.println("----------------------------------------");
    }

    public void execute(JCommander jcommander, String[] args) throws Exception {
        Object aux;
        this.commands.put("add", new AddTransformationCommand(jcommander));
        this.commands.put("add-module", new AddModuleCommand(jcommander));
        this.commands.put("add-param", new AddParamCommand(jcommander));
        this.commands.put("add-plugin", new AddPluginCommand(jcommander));
        this.commands.put("add-provider", new AddCfgProviderCommand(jcommander));
        this.commands.put("apply", new ApplyCommand(jcommander));
        this.commands.put("chains", new PrintChainsCommand(jcommander));
        this.commands.put("check", new CheckCommand(jcommander));
        this.commands.put("init", new InitCommand(jcommander));
        this.commands.put("inspect", new InspectCommand(jcommander));
        this.commands.put("install", new InstallCommand(jcommander));
        this.commands.put("modules", new PrintModulesCommand(jcommander));
        this.commands.put("providers", new PrintProvidersCommand(jcommander));
        this.commands.put("rm", new RemoveTransformationCommand(jcommander));
        this.commands.put("rm-chain", new RemoveChainCommand(jcommander));
        this.commands.put("rm-module", new RemoveModuleCommand(jcommander));
        this.commands.put("rm-plugin", new RemovePluginCommand(jcommander));
        this.commands.put("rm-provider", new RemoveProviderCommand(jcommander));
        this.commands.put("set-reader", new SetReaderCommand(jcommander));
        this.commands.put("set-writer", new SetWriterCommand(jcommander));
        this.commands.put("transformations", new PrintTransformationsCommand(jcommander));
        this.commands.put("plugins", new PrintPluginsCommand(jcommander));
        this.commands.put("--version", new VersionCommand());
        this.commands.put("--help", new HelpCommand(jcommander));
        Set<String> keys = this.commands.keySet();
        for (String key : keys) {
            if (!key.startsWith("--")) {
                jcommander.addCommand(key, (Object)this.commands.get(key));
            } else {
                jcommander.addCommand(key, (Object)this.commands.get(key), new String[]{"-" + key.charAt(2)});
            }
            aux = (JCommander)jcommander.getCommands().get(key);
            aux.setProgramName("walkmod " + key);
            aux.setAcceptUnknownOptions(false);
        }
        if (args == null || args.length == 0) {
            WalkModDispatcher.printHeader();
            new HelpCommand(jcommander).execute();
        } else {
            V2_AsciiTable table;
            try {
                jcommander.parse(args);
            }
            catch (ParameterException e) {
                System.out.println(e.getMessage());
                System.out.println("Run walkmod --help to see the accepted parameters");
                return;
            }
            String command = jcommander.getParsedCommand();
            WalkModDispatcher.printHeader();
            Command commandObject = this.commands.get(command.substring("walkmod ".length(), command.length()));
            commandObject.execute();
            if (commandObject instanceof AsciiTableAware && (table = (aux = (AsciiTableAware)((Object)commandObject)).getTable()) != null) {
                V2_AsciiTableRenderer rend = new V2_AsciiTableRenderer();
                rend.setTheme(V2_E_TableThemes.UTF_LIGHT.get());
                rend.setWidth((V2_Width)new AsciiTableWidth(50));
                RenderedTable rt = rend.render(table);
                System.out.println(rt);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        WalkModDispatcher instance = new WalkModDispatcher();
        JCommander command = new JCommander((Object)instance);
        command.setProgramName("walkmod");
        command.setAcceptUnknownOptions(false);
        instance.execute(command, args);
    }
}

