/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod;

import java.io.File;
import java.util.Map;
import org.walkmod.Options;

public class OptionsBuilder {
    private Options options;

    private OptionsBuilder() {
        this.options = new Options();
    }

    private OptionsBuilder(Map<String, Object> options) {
        this.options = new Options(options);
    }

    public static OptionsBuilder options() {
        return new OptionsBuilder();
    }

    public static OptionsBuilder options(Map<String, Object> options) {
        return new OptionsBuilder(options);
    }

    public OptionsBuilder offline(boolean offline) {
        this.options.setOffline(offline);
        return this;
    }

    public OptionsBuilder verbose(boolean verbose) {
        this.options.setVerbose(verbose);
        return this;
    }

    public OptionsBuilder printErrors(boolean printErrors) {
        this.options.setPrintErrors(printErrors);
        return this;
    }

    public OptionsBuilder throwException(boolean throwException) {
        this.options.setThrowException(throwException);
        return this;
    }

    public OptionsBuilder includes(String ... includes) {
        this.options.setIncludes(includes);
        return this;
    }

    public OptionsBuilder excludes(String ... excludes) {
        this.options.setExcludes(excludes);
        return this;
    }

    public OptionsBuilder executionDirectory(File executionDirectory) {
        this.options.setExecutionDirectory(executionDirectory);
        return this;
    }

    public OptionsBuilder configurationFormat(String configurationFormat) {
        this.options.setConfigurationFormat(configurationFormat);
        return this;
    }

    public Options build() {
        return this.options;
    }

    public Map<String, Object> asMap() {
        return this.options.asMap();
    }
}

