/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.writers;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.walkmod.ChainWriter;
import org.walkmod.walkers.VisitorContext;

public class VisitorMessagesWriter
implements ChainWriter {
    private static Logger log = Logger.getLogger(VisitorMessagesWriter.class);
    private String[] includes;
    private String[] excludes;

    @Override
    public void close() throws IOException {
        log.info((Object)"WRITE SUCCESSFUL");
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public void setPath(String path) {
    }

    @Override
    public void write(Object n, VisitorContext vc) {
        File out = null;
        if (vc != null) {
            out = (File)vc.get("original_file_key");
        }
        boolean write = true;
        if (out != null) {
            Collection<String> messages;
            int i;
            if (this.excludes != null) {
                for (i = 0; i < this.excludes.length && write; ++i) {
                    write = !FilenameUtils.wildcardMatch((String)out.getPath(), (String)this.excludes[i]);
                }
            }
            if (this.includes != null && write) {
                write = false;
                for (i = 0; i < this.includes.length && !write; ++i) {
                    write = FilenameUtils.wildcardMatch((String)out.getPath(), (String)this.includes[i]);
                }
            }
            if (write && (messages = vc.getVisitorMessages()) != null) {
                for (String message : messages) {
                    log.info((Object)message);
                }
            }
        }
    }

    @Override
    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    @Override
    public String[] getExcludes() {
        return this.excludes;
    }

    @Override
    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    @Override
    public String[] getIncludes() {
        return this.includes;
    }
}

