/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.writers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.walkmod.ChainWriter;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.walkers.VisitorContext;
import org.walkmod.writers.Summary;

public abstract class AbstractFileWriter
implements ChainWriter {
    private String[] excludes;
    private String[] includes;
    private File outputDirectory;
    private String normalizedOutputDirectory;
    private String encoding = "UTF-8";
    private static Logger log = Logger.getLogger(AbstractFileWriter.class);

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = new File(outputDirectory);
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdir();
        }
        this.normalizedOutputDirectory = FilenameUtils.normalize((String)this.outputDirectory.getAbsolutePath(), (boolean)true);
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public abstract File createOutputDirectory(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object n, VisitorContext vc) throws Exception {
        block24: {
            File out = null;
            boolean createdEmptyFile = false;
            if (vc != null) {
                out = (File)vc.get("original_file_key");
            }
            if (out == null) {
                log.debug((Object)"Creating the target source file. This is not the original source file.");
                out = this.createOutputDirectory(n);
                createdEmptyFile = true;
            } else {
                log.debug((Object)"The system will overwrite the original source file.");
            }
            boolean write = true;
            if (out != null) {
                int i;
                log.debug((Object)"Analyzing exclude and include rules");
                String aux = FilenameUtils.normalize((String)out.getAbsolutePath(), (boolean)true);
                if (this.excludes != null) {
                    for (i = 0; i < this.excludes.length && write; ++i) {
                        if (!this.excludes[i].startsWith(this.normalizedOutputDirectory)) {
                            this.excludes[i] = this.normalizedOutputDirectory + "/" + this.excludes[i];
                            if (this.excludes[i].endsWith("\\*\\*")) {
                                this.excludes[i] = this.excludes[i].substring(0, this.excludes[i].length() - 2);
                            }
                        }
                        write = !this.excludes[i].startsWith(aux) && !FilenameUtils.wildcardMatch((String)aux, (String)this.excludes[i]);
                    }
                }
                if (this.includes != null && write) {
                    write = false;
                    for (i = 0; i < this.includes.length && !write; ++i) {
                        if (!this.includes[i].startsWith(this.normalizedOutputDirectory)) {
                            this.includes[i] = this.normalizedOutputDirectory + "/" + this.includes[i];
                            if (this.includes[i].endsWith("\\*\\*")) {
                                this.includes[i] = this.includes[i].substring(0, this.includes[i].length() - 2);
                            }
                        }
                        write = this.includes[i].startsWith(aux) || FilenameUtils.wildcardMatch((String)aux, (String)this.includes[i]);
                    }
                }
                if (write) {
                    Writer writer = null;
                    try {
                        vc.put("outFile", (Object)out);
                        String content = this.getContent(n, vc);
                        vc.remove("outFile");
                        if (content != null && !"".equals(content)) {
                            char endLineChar = this.getEndLineChar(out);
                            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), this.getEncoding()));
                            if (vc.get("append") == null) {
                                this.write(content, writer, endLineChar);
                            } else if (Boolean.TRUE.equals(vc.get("append"))) {
                                this.append(content, writer, endLineChar);
                            } else {
                                this.write(content, writer, endLineChar);
                            }
                            Summary.getInstance().addFile(out);
                            log.debug((Object)(out.getPath() + " written "));
                            break block24;
                        }
                        log.error((Object)(out.getPath() + " does not have valid content"));
                        throw new WalkModException("blank code is returned");
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                }
                if (createdEmptyFile && out != null && out.isFile()) {
                    out.delete();
                }
                log.debug((Object)("skipping " + out.getParent()));
            } else {
                log.debug((Object)"There is no place where to write.");
            }
        }
    }

    public void write(String content, Writer writer, char endLineChar) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(content));
        String line = reader.readLine();
        String endLine = "\n";
        if (endLineChar == '\r') {
            endLine = "\r\n";
        }
        while (line != null) {
            writer.write(line + endLine);
            line = reader.readLine();
        }
    }

    public void append(String content, Writer writer, char endLineChar) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(content));
        String line = reader.readLine();
        String endLine = "\n";
        if (endLineChar == '\r') {
            endLine = "\r\n";
        }
        while (line != null) {
            writer.append(line + endLine);
            line = reader.readLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char getEndLineChar(File file) throws IOException {
        int endLineChar = 10;
        if (file.exists()) {
            FileReader reader = new FileReader(file);
            try {
                char[] buffer = new char[150];
                boolean detected = false;
                int bytes = reader.read(buffer);
                int previousChar = 0;
                while (bytes > 0 && !detected) {
                    for (int i = 0; i < bytes && !detected; ++i) {
                        if (buffer[i] == '\r') {
                            endLineChar = 13;
                            detected = true;
                        }
                        detected = detected || previousChar == 10 && buffer[i] != '\r';
                        previousChar = buffer[i];
                    }
                    if (detected) continue;
                    bytes = reader.read(buffer);
                }
            }
            finally {
                reader.close();
            }
        } else {
            String os = System.getProperty("os.name");
            if (os.toLowerCase().startsWith("windows")) {
                endLineChar = 13;
            }
        }
        return (char)endLineChar;
    }

    public abstract String getContent(Object var1, VisitorContext var2);

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void setPath(String path) {
        this.setOutputDirectory(path);
    }

    @Override
    public String getPath() {
        return this.outputDirectory.getPath();
    }

    @Override
    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    @Override
    public String[] getExcludes() {
        return this.excludes;
    }

    @Override
    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    @Override
    public String[] getIncludes() {
        return this.includes;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        log.debug((Object)("[encoding]:" + encoding));
    }
}

