/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.walkers;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.walkmod.conf.entities.ChainConfig;

public class VisitorContext
extends HashMap<String, Object> {
    private static final long serialVersionUID = 2667087124958777943L;
    private static final String KEY_AST_RESULT_NODES = "result";
    private Collection<String> visitorMessages = new LinkedList<String>();
    private ChainConfig ac = null;

    public VisitorContext() {
    }

    public VisitorContext(ChainConfig ac) {
        this();
        this.ac = ac;
    }

    public boolean addResultNode(Object node) {
        if (!super.containsKey(KEY_AST_RESULT_NODES)) {
            super.put(KEY_AST_RESULT_NODES, new LinkedList());
        }
        Collection collection = (Collection)this.get(KEY_AST_RESULT_NODES);
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            if (it.next() != node) continue;
            it.remove();
        }
        return collection.add(node);
    }

    public boolean addAllResultNodes(Collection<Object> nodes) {
        if (!super.containsKey(KEY_AST_RESULT_NODES)) {
            super.put(KEY_AST_RESULT_NODES, new LinkedList());
        }
        Collection collection = (Collection)this.get(KEY_AST_RESULT_NODES);
        boolean added = false;
        for (Object o : nodes) {
            added = this.addResultNode(o) || added;
        }
        return added;
    }

    @Override
    public Object remove(Object key) {
        if (!KEY_AST_RESULT_NODES.equals(key)) {
            return super.remove(key);
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        if (!KEY_AST_RESULT_NODES.equals(key)) {
            return super.put(key, value);
        }
        return null;
    }

    public Collection<Object> getResultNodes() {
        Collection result = super.containsKey(KEY_AST_RESULT_NODES) ? (Collection)this.get(KEY_AST_RESULT_NODES) : Collections.EMPTY_LIST;
        return result;
    }

    public boolean hasResultNodes() {
        return !this.getResultNodes().isEmpty();
    }

    public ChainConfig getArchitectureConfig() {
        return this.ac;
    }

    public void addTransformationMessage(String message) {
        this.visitorMessages.add(message);
    }

    public Collection<String> getVisitorMessages() {
        return this.visitorMessages;
    }

    public Object getBean(String name, Map<?, ?> parameters) {
        return this.getArchitectureConfig().getConfiguration().getBean(name, parameters);
    }

    public ClassLoader getClassLoader() {
        if (this.getArchitectureConfig() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return this.getArchitectureConfig().getConfiguration().getClassLoader();
    }

    public URI getResource(String resource) {
        URL url = this.getClassLoader().getResource(resource);
        if (url == null) {
            File file = new File(resource);
            if (file.exists()) {
                return file.toURI();
            }
            return null;
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

