/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.walkers;

import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ChangeLogPrinter {
    private Map<String, Integer> added;
    private Map<String, Integer> deleted;
    private Map<String, Integer> updated;
    private Map<String, Integer> unmodified;
    private static Logger log = Logger.getLogger(ChangeLogPrinter.class);

    public ChangeLogPrinter(Map<String, Integer> added, Map<String, Integer> updated, Map<String, Integer> deleted, Map<String, Integer> unmodified) {
        this.added = added;
        this.updated = updated;
        this.deleted = deleted;
        this.unmodified = unmodified;
    }

    private void printChangesByKey() {
        Set<String> keys = this.added.keySet();
        for (String key : keys) {
            String aux = String.valueOf(key.charAt(0)).toLowerCase() + key.substring(1);
            String[] label = aux.split("(?=\\p{Upper})");
            String printedLabel = "";
            if (label != null) {
                for (int i = 0; i < label.length; ++i) {
                    if ("Declaration".equals(label[i])) continue;
                    printedLabel = i > 0 ? printedLabel + " " + label[i].toLowerCase() : label[i].toLowerCase();
                }
            }
            int total = this.added.get(key) + this.deleted.get(key) + this.updated.get(key) + this.unmodified.get(key);
            String resume = "";
            if (total == this.unmodified.get(key)) {
                resume = printedLabel + "s : [changes : 0]";
            } else {
                String addedMsg = "0";
                String deletedMsg = "0";
                String updatedMsg = "0";
                int addedItems = this.added.get(key);
                int deletedItems = this.deleted.get(key);
                int updatedItems = this.updated.get(key);
                if (addedItems > 0) {
                    addedMsg = addedItems + "/" + total;
                }
                if (deletedItems > 0) {
                    deletedMsg = deletedItems + "/" + total;
                }
                if (updatedItems > 0) {
                    updatedMsg = updatedItems + "/" + total;
                }
                resume = printedLabel + "s : [ added: " + addedMsg + ", deleted: " + deletedMsg + ", updated: " + updatedMsg + "]";
            }
            log.debug((Object)resume);
        }
    }

    public void print() {
        this.printChangesByKey();
    }
}

